---
title: Resolve a payment failure · Cloudflare Billing docs
description: "This article will help if you are receiving errors about your
  payment failing when attempting to purchase something, change an existing
  subscription, pay an invoice or an outstanding balance. You may see one of the
  following error messages:"
lastUpdated: 2025-08-21T17:26:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/billing/troubleshoot-failed-payments/
  md: https://developers.cloudflare.com/billing/troubleshoot-failed-payments/index.md
---

This article will help if you are receiving errors about your payment failing when attempting to purchase something, change an existing subscription, pay an invoice or an outstanding balance. You may see one of the following error messages:

* "Contact your bank for assistance. An error occurred while collecting payment."
* "Payment error: authorization failed for \[“example.com”]"
* "failed in ActionAppendSubscription: failed to update user subscription: failed to apply object products: failed to collect latest invoice XXXXXX for subscription YYYYY: Contact your bank for assistance. An error occurred while collecting payment."

Alternatively, you may receive an email from us about a subscription renewal payment failure with the subject: “\[Cloudflare]: We couldn't process your renewal payment” which states “We were unable to process your renewal payment”.

## Automatic retries and product removal

If the failed payment relates to a recurring charge for a Cloudflare plan, add-on, or subscription then after a five (5) day grace period, your account is automatically downgraded to a Free plan. Downgrading to a Free plan does not suspend your website, but you will lose any subscriptions or add-on services associated with the Pro, Business, or Enterprise plan.

To avoid this, follow the Causes & Solution sections below to resolve the failing payment and retry. If you are unable to resolve the issue within the 5 day grace period, you’ll need to manually re-subscribe to these products. You may need to [pay an overdue balance](https://developers.cloudflare.com/billing/pay-invoices-overdue-balances/#pay-an-overdue-balance) relating to the five day grace period, if applicable.

## Causes

* Your card details are incorrect
* There are not enough funds in your account
* You did not pass 3D Secure (3DS) correctly
* Your bank is rate limiting payments from us
* Your bank is declining the payment

## Solution

### Check your details & contact your bank

#### Check your card details

* Check your address is valid and matches the one registered with your bank for the payment method you are using
* Check that the Card Verification Value (CVC) you entered is correct for your card
* If you are using PayPal, check for a verification email to your PayPal email address and follow the instructions to authorize

#### Check you have enough funds

Double check your payment method’s balance to ensure that your account has enough funds.

#### Correctly authorise your transaction with 3D Secure (3DS)

You may be using a bank that mandates the use of 3D Secure (3DS) for online card transactions. For one off or first time subscription payments, you need to be prepared to pass 3DS authentication when you attempt the payment in the Cloudflare dashboard. Your bank will contact you to authorise the transaction in real time. This contact typically comes via an SMS or push notification from your bank’s mobile application.

Please note that for customers of Indian banks, 3DS is mandatory for all transactions as per the mandate from the Reserve Bank of India (RBI).

#### Contact your bank if purchasing / renewing Registrar domains

If you were purchasing or renewing multiple domains via [Cloudflare Registrar](https://developers.cloudflare.com/registrar) each domain will be charged as a separate transaction. This may be flagged as fraud by your credit card company. You will need to contact your bank in order to confirm and resolve this.

#### Contact your bank to understand & fix the declined payment

Cloudflare’s payment system does not know why a payment was declined, so you should contact your bank to confirm specifically why they declined the payment.

### Try your payment again

Once you have checked the items above, you should try your transaction again by visiting the Cloudflare dashboard. If the payment that failed was a renewal payment, we will retry automatically 5 times in 5 days. However, we recommend you retry the payment manually in the dashboard to receive instant feedback. To do this:

1. Log into the [Cloudflare dashboard](https://dash.cloudflare.com) and select your account.
2. Go to **Manage Account > Billing**.
3. Go to **Invoices and documents**.
4. Click **Pay Now** next to your invoice OR from the Invoice PDF, click the payment link.
5. Follow the on screen instructions to try again.

### Try a new payment method

If you cannot resolve this using your current payment method, you may wish to try an alternative payment method. We support multiple different credit card types and PayPal. To try this, refer [add a new payment method](https://developers.cloudflare.com/billing/update-billing-info/#update-payment-methods).
