---
title: Match Workers subrequests by upstream zone — cf.worker.upstream_zone now
  supported in Transform Rules · Changelog
description: Transform Rules now support the cf.worker.upstream_zone field,
  letting you conditionally apply rules based on which zone sent Workers
  subrequest.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-06-09-transform-rule-subrequest-matching/
  md: https://developers.cloudflare.com/changelog/2025-06-09-transform-rule-subrequest-matching/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Match Workers subrequests by upstream zone — cf.worker.upstream\_zone now supported in Transform Rules

Jun 09, 2025

[Rules](https://developers.cloudflare.com/rules/)

You can now use the [`cf.worker.upstream_zone`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.worker.upstream_zone/) field in [Transform Rules](https://developers.cloudflare.com/rules/transform/) to control rule execution based on whether a request originates from [Workers](https://developers.cloudflare.com/workers/), including subrequests issued by Workers in other zones.

![Match Workers subrequests by upstream zone in Transform Rules](https://developers.cloudflare.com/_astro/transform-rule-subrequest-matching.BeUBEN67_10A2ms.webp)

**What's new:**

* `cf.worker.upstream_zone` is now supported in Transform Rules expressions.
* Skip or apply logic conditionally when handling [Workers subrequests](https://developers.cloudflare.com/workers/platform/limits/#subrequests).

For example, to add a header when the subrequest comes from another zone:

Text in **Expression Editor** (replace `myappexample.com` with your domain):

```txt
(cf.worker.upstream_zone != "" and cf.worker.upstream_zone != "myappexample.com")
```

Selected operation under **Modify request header**: *Set static*

**Header name**: `X-External-Workers-Subrequest`

**Value**: `1`

This gives you more granular control in how you handle incoming requests for your zone.

Learn more in the [Transform Rules](https://developers.cloudflare.com/rules/transform/) documentation and [Rules language fields](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/) reference.
