---
title: Hexnode · Cloudflare Zero Trust docs
description: Deploy Cloudflare WARP with Hexnode MDM - Step-by-step guide for
  Windows, macOS, iOS, and Android.
lastUpdated: 2025-08-20T21:45:15.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/mdm-deployment/partners/hexnode/
  md: https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/mdm-deployment/partners/hexnode/index.md
---

## Windows

1. Create a script file with `.bat`, `.cmd`, and `.ps1` file formats to download, install and configure the Cloudflare WARP client Windows application on the device. Listed below is a sample script with all of the configurable parameters:

   ```python
   <# Choose file name for downloading application #>
   $filename = filename.msi'


   <# Download URL of the installer. #>
   $url = 'https://downloads.cloudflareclient.com/v1/download/windows/ga'
   Write-Host 'Downloading App from' $url
   Invoke-WebRequest -Uri $url -OutFile $filename


   <# Run the installer and wait for the installation to finish #>
   $arguments = "ORGANIZATION="exampleorg" SERVICE_MODE="warp" GATEWAY_UNIQUE_ID="fmxk762nrj" SUPPORT_URL="http://support.example.com""


   $installProcess = (Start-Process $filename -ArgumentList $arguments -PassThru -Wait)


   <# Check if installation was successful #>
   if ($installProcess.ExitCode -ne 0) {
       Write-Host "Installation failed!"
       exit $installProcess.ExitCode
   }
   else {
       Write-Host "Installation completed successfully!"
   }
   ```

2. Push the script file to the devices using Hexnode.

3. On your Hexnode console, go to **Manage** > **Devices**.

4. Select your device name. This will take you to the **Device Summary**.

5. Select **Actions** > **Execute Custom Script**.

6. Choose the script file source as *Upload file*, then upload the script file.

7. Select **Execute**.

After deploying the WARP client, you can check its connection progress using the [Connectivity status](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/troubleshooting/connectivity-status/) messages displayed in the WARP GUI.

## macOS

1. [Download](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/download-warp/#macos) the Cloudflare WARP client for macOS.

2. On your Hexnode console, go to **Apps** > **Add Apps** > **Enterprise App**.

3. Select *macOS* as the app platform.

4. Add an app name, category and description.

5. Upload the `Cloudflare_WARP_<VERSION>.pkg` file and select **Add**.

6. Set up an XML file with the supported app configurations for the app. Here is a sample XML file with the accepted parameters.

   ```xml
   <?xml version="1.0" encoding="UTF-8"?>
   <!DOCTYPE plist PUBLIC "-//Apple//DTD PLIST 1.0//EN" "http://www.apple.com/DTDs/PropertyList-1.0.dtd">
   <plist version="1.0">
   <dict>
   <key>organization</key>
   <string>organizationname</string>
   <key>auto_connect</key>
   <integer>1</integer>
   <key>switch_locked</key>
   <false />
   <key>service_mode</key>
   <string>warp</string>
   <key>support_url</key>
   <string>https://support.example.com</string>
   </dict>
   </plist>
   ```

7. On your Hexnode console, go to **Policies**.

8. Create a new policy and provide a policy name.

9. Go to **macOS** > **App Management** > **Mandatory Apps** and start setting up the policy.

10. Select **Add** and select the previously uploaded WARP client app.

11. Go to **App Configurations** > **Add new configuration**.

12. Select the *WARP client* app and upload the XML file from Step 6.

13. Now go to **Policy Targets** and associate the policy with the target entities.

This will push the app along with the configurations to the selected devices.

After deploying the WARP client, you can check its connection progress using the [Connectivity status](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/troubleshooting/connectivity-status/) messages displayed in the WARP GUI.

## iOS

1. On your Hexnode console, go to **Apps** > **Add Apps** > **Store App**.

2. Select *iOS* as the app platform.

3. Search for [**Cloudflare One Agent**](https://apps.apple.com/us/app/cloudflare-one-agent/id6443476492) and **Add** the app.

4. Set up an XML file with the supported app configurations for the app. Refer this sample XML code to identify the supported arguments:

   ```xml
   <dict>
   <key>organization</key>
   <string>yourorganization</string>
   <key>auto_connect</key>
   <integer>1</integer>
   <key>switch_locked</key>
   <false />
   <key>service_mode</key>
   <string>warp</string>
   <key>support_url</key
   <string>https://support.example.com</string>
   </dict>
   ```

5. Upload the app configurations in Hexnode:

   1. On your Hexnode console, go to the **Apps** tab.
   2. Find the Cloudflare One Agent app and select its name.
   3. Select the settings icon and choose **App Configuration**.
   4. Upload the XML file in the corresponding field.
   5. Select **Save**.

6. Push the app to the target devices using Hexnode.

   1. On your Hexnode console, go to **Policies** and create a new policy.
   2. Provide a name for the policy and go to **iOS**.
   3. Go to **Mandatory Apps** > **Configure**.
   4. Select **Add** > **Add app**, check the required app, and select **Done**.
   5. Go to **Policy Targets** and associate the policy with the required target devices.

This will push the app along with the configurations to the selected devices.

After deploying the WARP client, you can check its connection progress using the [Connectivity status](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/troubleshooting/connectivity-status/) messages displayed in the WARP GUI.

## Android

1. On your Hexnode console, go to **Apps** > **Add Apps** > **Managed Google Apps**.
2. Search for the app [**Cloudflare One Agent**](https://play.google.com/store/apps/details?id=com.cloudflare.cloudflareoneagent).
3. Approve the app as a Managed Google Play app.
4. Go to **Policies** and create a new policy.
5. Go to **Android** > **App Configurations** > **Add new configuration**.
6. Find the **Cloudflare One Agent** app and set up your custom configurations.
7. Go to **Policy Targets** and associate the policy with the required target devices.
8. Save the policy.

This will push the app along with the configurations to the selected devices.

After deploying the WARP client, you can check its connection progress using the [Connectivity status](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/troubleshooting/connectivity-status/) messages displayed in the WARP GUI.
