---
title: Uptycs · Cloudflare Zero Trust docs
description: Cloudflare Zero Trust can integrate with Uptycs to require that
  users connect to certain applications from managed devices. This
  service-to-service posture check uses the WARP client to read endpoint data
  from Uptycs. Devices are identified by their serial numbers. If multiple
  devices have the same serial number, Cloudflare cannot accurately match a WARP
  device with a third-party provider device. You must ensure that each of your
  devices has a unique serial number.
lastUpdated: 2025-08-22T14:24:45.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/identity/devices/service-providers/uptycs/
  md: https://developers.cloudflare.com/cloudflare-one/identity/devices/service-providers/uptycs/index.md
---

Cloudflare Zero Trust can integrate with Uptycs to require that users connect to certain applications from managed devices. This service-to-service posture check uses the WARP client to read endpoint data from Uptycs. Devices are identified by their serial numbers. If multiple devices have the same serial number, Cloudflare cannot accurately match a WARP device with a third-party provider device. You must ensure that each of your devices has a unique serial number.

## Prerequisites

* Uptycs agent is deployed on the device.

* Cloudflare WARP client is [deployed](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/) on the device. For a list of supported modes and operating systems, refer to [Service providers](https://developers.cloudflare.com/cloudflare-one/identity/devices/service-providers/).

## 1. Obtain Uptycs Settings

The following Uptycs values are needed to set up the Uptycs posture check:

* Client key
* Client Secret
* Customer ID

To obtain these values:

1. Open your Uptycs console.
2. Go to **Account Settings** > **API Key**.
3. Generate and download your `.json` file. This file will contain your **Client key**, **Client Secret** and **Customer ID**.

## 2. Add Uptycs as a service provider

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Settings** > **WARP Client**.
2. Scroll down to **Third-party service provider integrations** and select **Add new**.
3. Select **Uptycs**.
4. Enter any name for the provider. This name will be used throughout the dashboard to reference this connection.

1) Enter the **Client ID**, **Client secret** and **Customer ID** as you noted down above.
2) Select a **Polling frequency** for how often Cloudflare Zero Trust should query Uptycs for information.
3) Select **Test and save**.

## 3. Configure the posture check

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Settings** > **WARP Client** > **Service provider checks**.
2. Select **Add new**.
3. Select the Uptycs provider.
4. Enter any name for the posture check.
5. Configure the [attributes](#device-posture-attributes) required for the device to pass the posture check.
6. Select **Save**.
7. To test, go to **Logs** > **Posture** and verify that the service provider posture check is returning the expected results.

You can now use this posture check in a [device posture policy](https://developers.cloudflare.com/cloudflare-one/identity/devices/#3-build-a-device-posture-policy).

## Device posture attributes

| Selector | Description |
| - | - |
| Score | Zero Trust score assigned to the device by Uptycs |
