---
title: CNAME flattening · Cloudflare DNS docs
description: CNAME flattening speeds up CNAME resolution and allows you to use a
  CNAME record at your zone apex (example.com).
lastUpdated: 2025-08-20T18:47:44.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/dns/cname-flattening/
  md: https://developers.cloudflare.com/dns/cname-flattening/index.md
---

CNAME flattening speeds up CNAME resolution and allows you to use a CNAME record at your [zone apex](https://developers.cloudflare.com/dns/concepts/#zone-apex) (`example.com`).

Note

This functionality is also what allows you to use a [root custom domain](https://developers.cloudflare.com/pages/configuration/custom-domains/) with a Cloudflare Pages site.

## How it works

With CNAME flattening, Cloudflare finds the IP address that a CNAME points to. This process could involve a single lookup or multiple (if your CNAME points to another CNAME). Cloudflare then returns the final IP address instead of a CNAME record, helping DNS queries resolve up to 30% faster.

For more details on the steps involved in CNAME flattening, review the [CNAME flattening diagram](https://developers.cloudflare.com/dns/cname-flattening/cname-flattening-diagram/) and refer to the [Cloudflare blog post](https://blog.cloudflare.com/introducing-cname-flattening-rfc-compliant-cnames-at-a-domains-root/).

Note

For information about CNAME flattening in [Internal DNS](https://developers.cloudflare.com/dns/internal-dns/), refer to [internal DNS records](https://developers.cloudflare.com/dns/internal-dns/internal-zones/internal-dns-records/).

## Aspects to keep in mind

* CNAME flattening happens by default in some cases. Refer to [Setup](https://developers.cloudflare.com/dns/cname-flattening/set-up-cname-flattening/) for details.

* If a CNAME target is being used to verify a domain for a third-party service, turning on [CNAME flattening for all CNAME records](https://developers.cloudflare.com/dns/cname-flattening/set-up-cname-flattening/#for-all-cname-records) may cause the verification to fail since the CNAME record itself will not be returned directly.
