---
title: Partial (CNAME) setup · Cloudflare DNS docs
description: A partial (CNAME) setup allows you to use Cloudflare's reverse
  proxy while maintaining your primary and authoritative DNS provider.
lastUpdated: 2025-08-20T18:47:44.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/dns/zone-setups/partial-setup/
  md: https://developers.cloudflare.com/dns/zone-setups/partial-setup/index.md
---

A partial (CNAME) setup allows you to use [Cloudflare's reverse proxy](https://developers.cloudflare.com/fundamentals/concepts/how-cloudflare-works/) while maintaining your primary and authoritative DNS provider.

Use this option to proxy only individual subdomains through Cloudflare when you cannot change your authoritative DNS provider. You will be able to create A, AAAA, and CNAME records, which are the DNS record types that can be [proxied](https://developers.cloudflare.com/dns/proxy-status/).

Once you are on a partial setup, the actual resolution of your records to Cloudflare depends on CNAME records [added at your authoritative DNS provider](https://developers.cloudflare.com/dns/zone-setups/partial-setup/setup/#3-add-dns-records). Check your authoritative DNS provider to know which records are pointing to `{your-hostname}.cdn.cloudflare.net`.

## How to

* [Set up a partial domain](https://developers.cloudflare.com/dns/zone-setups/partial-setup/setup/)
* [Convert a partial setup to a full setup](https://developers.cloudflare.com/dns/zone-setups/conversions/convert-partial-to-full/)
* [Convert a partial setup to a secondary setup](https://developers.cloudflare.com/dns/zone-setups/conversions/convert-partial-to-secondary/)
* [Create DNS records of other types](https://developers.cloudflare.com/dns/zone-setups/partial-setup/setup/#other-record-types)

## Availability

| | Free | Pro | Business | Enterprise |
| - | - | - | - | - |
| Availability | No | No | Yes | Yes |

## Reference

### DNS resolution

With a partial zone, Cloudflare resolves [DNS records differently](https://developers.cloudflare.com/dns/zone-setups/partial-setup/dns-resolution/) than for full zones.

### CNAME flattening

A partial (CNAME) setup requires the proxied hostname to be pointed to Cloudflare via a CNAME record. Since [CNAME records are not allowed on the zone apex](https://datatracker.ietf.org/doc/html/rfc1912#section-2.4) (`example.com`), you can only proxy your zone apex to Cloudflare if your authoritative DNS provider supports [CNAME Flattening](https://blog.cloudflare.com/introducing-cname-flattening-rfc-compliant-cnames-at-a-domains-root/).

If your authoritative DNS provider does not support CNAME Flattening, redirect its traffic — for example, with an `.htaccess` file — to a subdomain proxied to Cloudflare. Alternatively, you can use [static IPs or BYOIPs](https://developers.cloudflare.com/fundamentals/concepts/cloudflare-ip-addresses/#customize-cloudflare-ip-addresses).

### DDoS protection

[DDoS protection](https://developers.cloudflare.com/ddos-protection/) for attacks against DNS infrastructure is only available for domains on [full setup](https://developers.cloudflare.com/dns/zone-setups/full-setup/). Domains on the partial setup are not using Cloudflare authoritative nameservers.

### Domain ownership

Enterprise customers can use [zone holds](https://developers.cloudflare.com/fundamentals/account/account-security/zone-holds/) to prevent other teams in the organization from adding zones that are already active in another Cloudflare account. For partial setups, if the same zone is added to different accounts, the last account to complete the setup will gain ownership.
