---
title: Nameserver assignment · Cloudflare DNS docs
description: When you add a domain on a primary (full) or secondary DNS setup,
  Cloudflare automatically assigns your nameservers. You should then add the
  assigned nameservers to your registrar and, once Cloudflare can detect they
  have been placed, your zone is activated.
lastUpdated: 2024-12-13T16:58:23.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/dns/zone-setups/reference/nameserver-assignment/
  md: https://developers.cloudflare.com/dns/zone-setups/reference/nameserver-assignment/index.md
---

When you add a domain on a [primary (full)](https://developers.cloudflare.com/dns/zone-setups/full-setup/) or [secondary](https://developers.cloudflare.com/dns/zone-setups/zone-transfers/cloudflare-as-secondary/) DNS setup, Cloudflare automatically assigns your nameservers. You should then add the assigned nameservers to your registrar and, once Cloudflare can detect they have been placed, your zone is activated.

Each domain's assigned nameservers may be different than other domains, even if those domains are within the same account.

These nameserver assignments cannot be changed. However, depending on your subscription, you may have different options to [control the nameservers assignment method](https://developers.cloudflare.com/dns/nameservers/nameserver-options/#assignment-method) or to use your own [custom nameservers](https://developers.cloudflare.com/dns/nameservers/custom-nameservers/).

Warning

To prevent domain hijacking, you can no longer preset Cloudflare nameservers at your registrar before creating the respective zone in Cloudflare. If you preset your nameservers and then add the domain, your domain will be assigned a new pair of nameservers.

To keep the same nameservers across your domains, use [Account custom nameservers](https://developers.cloudflare.com/dns/nameservers/custom-nameservers/account-custom-nameservers/).

For more background on nameserver assignments, refer to [our blog](https://blog.cloudflare.com/whats-the-story-behind-the-names-of-cloudflares-name-servers/).
