---
title: Network Layers · Cloudflare Fundamentals docs
description: Below is a list of the different layers that makes up the open
  systems interconnection (OSI) model and the associated Cloudflare products.
lastUpdated: 2025-07-18T14:20:57.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/fundamentals/reference/network-layers/
  md: https://developers.cloudflare.com/fundamentals/reference/network-layers/index.md
---

Below is a list of the different layers that makes up the [open systems interconnection (OSI) model](https://www.cloudflare.com/learning/ddos/glossary/open-systems-interconnection-model-osi/) and the associated Cloudflare products.

Note

The list of related products is representative but not comprehensive.

| Network layer | Protocol and related products |
| - | - |
| 7 Application layer | **HTTP, DNS** [Authoritative DNS](https://developers.cloudflare.com/dns), [Bot Management](https://developers.cloudflare.com/bots), [CDN](https://developers.cloudflare.com/cache/), [Cloudflare Access](https://developers.cloudflare.com/cloudflare-one/policies/access/), [Cloudflare Gateway](https://developers.cloudflare.com/cloudflare-one/policies/gateway/) (outbound only), [Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/), [Load Balancing](https://developers.cloudflare.com/load-balancing/understand-basics/proxy-modes/), [Stream](https://developers.cloudflare.com/stream/), [WAF](https://developers.cloudflare.com/waf/) |
| 6 Presentation layer | |
| 5 Session layer | |
| 4 Transport layer | **TCP/UDP** [Argo Smart Routing](https://developers.cloudflare.com/argo-smart-routing/), [Cloudflare Gateway](https://developers.cloudflare.com/cloudflare-one/policies/gateway/) (outbound only), [Load Balancing](https://developers.cloudflare.com/load-balancing/understand-basics/proxy-modes/), [Spectrum](https://developers.cloudflare.com/spectrum/) |
| 3 Network layer | **IP, GRE, any packet/protocol** [Magic Firewall](https://developers.cloudflare.com/magic-firewall), [Magic Transit](https://developers.cloudflare.com/magic-transit), [Magic WAN](https://developers.cloudflare.com/magic-wan) |
| 2 Datalink layer | **Direct connection** [Cloudflare Network Interconnect (CNI)](https://developers.cloudflare.com/network-interconnect) |
| 1 Physical layer | **Direct connection** [Cloudflare Network Interconnect (CNI)](https://developers.cloudflare.com/network-interconnect) |
