---
title: DDoS Protection · Cloudflare Learning Paths
description: Cloudflare automatically detects and mitigates DDoS attacks using
  its Autonomous Edge, which is always-on. Advanced protections are reserved for
  Magic Transit customers.
lastUpdated: 2025-06-16T19:13:27.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/application-security/default-traffic-security/ddos/
  md: https://developers.cloudflare.com/learning-paths/application-security/default-traffic-security/ddos/index.md
---

Cloudflare automatically detects and mitigates DDoS attacks using its [Autonomous Edge](https://developers.cloudflare.com/ddos-protection/about/components/#autonomous-edge), which is always-on. `Advanced` protections are reserved for Magic Transit customers.

| OSI Layer | Ruleset / Feature | Example of covered DDoS attack vectors |
| - | - | - |
| L3/4 | [Network-layer DDoS Attack Protection](https://developers.cloudflare.com/ddos-protection/managed-rulesets/network/) | UDP flood attack SYN floods SYN-ACK reflection attack ACK floods Mirai and Mirai-variant L3/4 attacks ICMP flood attack SNMP flood attack QUIC flood attack Out of state TCP attacks Protocol violation attacks SIP attacks ESP flood DNS amplification attack DNS Garbage Flood DNS NXDOMAIN flood DNS Query flood RST flood NetBios DDoS attacks mDNS DDoS attacks VxWorks DDoS attacks BitTorrent reflection attack Memcached amplification attacks CHARGEN reflection attacks Ubiquity reflection attacks Lantronix reflection attacks SSDP reflection attacks MSSQL reflection attacks DTLS amplification attacks Quote of the Day (QOTD) reflection attacks TeamSpeak 3 floods Jenkins amplification attacks GRE floods SPSS reflection attacks Carpet Bombing attacks For more DNS protection options, refer to [Getting additional DNS protection](https://developers.cloudflare.com/ddos-protection/about/attack-coverage/#getting-additional-dns-protection). |
| L3/4 | [Advanced TCP Protection](https://developers.cloudflare.com/ddos-protection/advanced-ddos-systems/overview/advanced-tcp-protection/) [1](#user-content-fn-1) | Fully randomized and spoofed ACK floods, SYN floods, SYN-ACK reflection attacks, and other sophisticated TCP-based DDoS attacks |
| L7 (DNS) | [Advanced DNS Protection](https://developers.cloudflare.com/ddos-protection/advanced-ddos-systems/overview/advanced-dns-protection/) [1](#user-content-fn-1) | Sophisticated and fully randomized DNS attacks, including Water Torture attacks, Random-prefix attacks, and DNS laundering attacks. |
| L7 (HTTP/S) | [HTTP DDoS Attack Protection](https://developers.cloudflare.com/ddos-protection/managed-rulesets/http/) | HTTP flood attack WordPress pingback attack HULK attack LOIC attack Slowloris attack Mirai and Mirai-variant HTTP attacks HTTP/2 Rapid Reset HTTP Continuation flood Cache busting attacks Known DDoS botnets TLS/SSL negotiation attacks TLS/SSL exhaustion attacks Carpet Bombing attacks  |

## Footnotes

1. Available to Magic Transit customers. [↩](#user-content-fnref-1) [↩2](#user-content-fnref-1-2)

Refer to the learning path [Prevent DDoS attacks](https://developers.cloudflare.com/learning-paths/prevent-ddos-attacks/concepts/) to dive deeper into this subject.
