---
title: Benefits of using Magic Transit · Cloudflare Learning Paths
description: Magic Transit leverages Cloudflare's global anycast network. As of
  writing this guide, Cloudflare's global network spans over 330 cities, and has
  over 405 Tbps network capacity. This bandwidth allows it to absorb all manners
  of attack that otherwise would overwhelm a typical data center or on-premise
  hardware Distributed Denial-of-Service (DDoS) appliances.
lastUpdated: 2025-05-16T09:55:07.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/data-center-protection/concepts/benefits-magic-transit/
  md: https://developers.cloudflare.com/learning-paths/data-center-protection/concepts/benefits-magic-transit/index.md
---

Magic Transit leverages Cloudflare's global anycast network. As of writing this guide, Cloudflare's global network spans over 330 cities, and has over 405 Tbps network capacity. This bandwidth allows it to absorb all manners of attack that otherwise would overwhelm a typical data center or on-premise hardware Distributed Denial-of-Service (DDoS) appliances.

The number of DDoS attacks has been steadily increasing in recent years. In the first quarter of 2025, Cloudflare [mitigated 16.8 million network-layer DDoS attacks](https://blog.cloudflare.com/ddos-threat-report-for-2025-q1/#ddos-attacks-in-numbers). This represents a 397% increase quarter over quarter and a 509% increase year over year.

Other advantages of choosing Magic Transit:

* **Scalability**: As Cloudflare's global network expands, so does Magic Transit ability to absorb ever bigger DDoS attacks.
* **Ease of management**: Magic Transit offers centralized, cloud-based management tools that simplify configuration and monitoring of your network security.
* **Improvement of network performance**: Magic Transit steers traffic along tunnel routes based on priorities you define and uses equal-cost multi-path routing to provide load-balancing across tunnels with the same prefix and priority.
* **Integration with zero-trust services**: Magic Transit integrates with other Cloudflare products, including Cloudflare One's SASE offerings, Magic Firewall, and more.
* **Integration with CNI**: Directly connect your infrastructure to Cloudflare with CNI and bypass the Internet. Beyond a more reliable and secure experience, using CNI is an alternative to anycast GRE tunnels for getting traffic delivered to your infrastructure with a 1500-byte maximum transmission unit (MTU) handoff.
* **Real-time traffic visibility and alerting**: Monitor and analyze traffic patterns, threat activity, and mitigation actions in real time through Cloudflare's analytics and logging tools. Set up customized alerts to notify you of potential threats, enabling faster incident response and better-informed network decisions.
