---
title: Recommended DNS policies · Cloudflare Learning Paths
description: We recommend you add the following DNS policies to build an
  Internet and SaaS app security strategy for your organization.
lastUpdated: 2025-08-22T14:24:45.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/secure-internet-traffic/build-dns-policies/recommended-dns-policies/
  md: https://developers.cloudflare.com/learning-paths/secure-internet-traffic/build-dns-policies/recommended-dns-policies/index.md
---

We recommend you add the following DNS policies to build an Internet and SaaS app security strategy for your organization.

## All-DNS-Domain-Allowlist

Allowlist any known domains and hostnames. With this policy, you ensure that your users can access your organization's domains even if the domains fall under a blocked category, such as **Newly Seen Domains** or **Login Screens**.

* Dashboard

  | Selector | Operator | Value | Logic | Action |
  | - | - | - | - | - |
  | Domain | in list | *Known Domains* | Or | Allow |
  | Host | in list | *Known Domains* | | |

* API

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "name": "All-DNS-Domain-Allowlist",
      "description": "Allowlist any known domains and hostnames",
      "precedence": 0,
      "enabled": true,
      "action": "allow",
      "filters": [
          "dns"
      ],
      "traffic": "any(dns.domains[*] in $<KNOWN_DOMAINS_LIST_UUID>) or dns.fqdn in $<KNOWN_DOMAINS_LIST_UUID>"
    }'
  ```

* Terraform

  ```tf
  resource "cloudflare_zero_trust_gateway_policy" "dns_whitelist_policy" {
    account_id  = var.cloudflare_account_id
    name        = "All-DNS-Domain-Allowlist"
    description = "Allowlist any known domains and hostnames"
    precedence  = 0
    enabled     = true
    action      = "allow"
    filters     = ["dns"]
    traffic     = "any(dns.domains[*] in ${"$"}${cloudflare_zero_trust_list.domain_whitelist.id}) or dns.fqdn in ${"$"}${cloudflare_zero_trust_list.domain_whitelist.id}"
  }
  ```

## Quarantined-Users-DNS-Restricted-Access

Restrict access for users included in an identity provider (IdP) user group for risky users. This policy ensures your security team can restrict traffic for users of whom malicious or suspicious activity was detected.

* Dashboard

  | Selector | Operator | Value | Logic | Action |
  | - | - | - | - | - |
  | Domain | not in list | *Allowed Remediation Domains* | Or | Block |
  | Host | not in list | *Allowed Remediation Domains* | And | |
  | User Group Names | in | *Quarantined Users* | | |

* API

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "name": "Quarantined-Users-DNS-Restricted-Access",
      "description": "Restrict access for users included in an identity provider (IdP) user group for risky users",
      "precedence": 10,
      "enabled": true,
      "action": "block",
      "filters": [
          "dns"
      ],
      "traffic": "not(any(dns.domains[] in $<ALLOWED_REMEDIATION_DOMAINS_LIST_UUID>)) or not(any(dns.domains[] in $<ALLOWED_REMEDIATION_DOMAINS_LIST_UUID>))",
      "identity": "any(identity.groups.name[*] in {\"Quarantined Users\"})"
    }'
  ```

* Terraform

  ```tf
  resource "cloudflare_zero_trust_gateway_policy" "dns_restrict_quarantined_users" {
    account_id  = var.cloudflare_account_id
    name        = "Quarantined-Users-DNS-Restricted-Access"
    description = "Restrict access for users included in an identity provider (IdP) user group for risky users"
    precedence  = 10
    enabled     = true
    action      = "block"
    filters     = ["dns"]
    traffic     = "not(any(dns.domains[*] in ${"$"}${cloudflare_zero_trust_list.allowed_remediation_domains.id})) or not(any(dns.domains[*] in ${"$"}${cloudflare_zero_trust_list.allowed_remediation_domains.id}))"
    identity    =  "any(identity.groups.name[*] in {\"Quarantined Users\"})"
  }
  ```

## All-DNS-SecurityCategories-Blocklist

Block [security categories](https://developers.cloudflare.com/cloudflare-one/policies/gateway/domain-categories/#security-categories), such as **Command and Control & Botnet** and **Malware**, based on Cloudflare's threat intelligence.

* Dashboard

  | Selector | Operator | Value | Action |
  | - | - | - | - |
  | Security Categories | in | *All security risks* | Block |

* API

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "name": "All-DNS-SecurityCategories-Blocklist",
      "description": "Block security categories based on Cloudflare'\''s threat intelligence",
      "precedence": 20,
      "enabled": true,
      "action": "block",
      "filters": [
          "dns"
      ],
      "traffic": "any(dns.security_category[*] in {68 178 80 83 176 175 117 131 134 151 153})",
      "identity": ""
    }'
  ```

* Terraform

  ```tf
  resource "cloudflare_zero_trust_gateway_policy" "block_security_threats" {
    account_id  = var.cloudflare_account_id
    name        = "All-DNS-SecurityCategories-Blocklist"
    description = "Block security categories based on Cloudflare's threat intelligence"
    precedence  = 20
    enabled     = true
    action      = "block"
    filters     = ["dns"]
    traffic     = "any(dns.security_category[*] in {68 178 80 83 176 175 117 131 134 151 153})"
  }
  ```

## All-DNS-ContentCategories-Blocklist

Entries in the [security risk content subcategory](https://developers.cloudflare.com/cloudflare-one/policies/gateway/domain-categories/#security-risk-subcategories), such as **New Domains**, do not always pose a security threat. We recommend you first create an Allow policy to track policy matching and identify any false positives. You can add false positives to your **Trusted Domains** list used in **All-DNS-Domain-Allowlist**.

After your test is complete, we recommend you change the action to Block to minimize risk to your organization.

* Dashboard

  | Selector | Operator | Value | Action |
  | - | - | - | - |
  | Content Categories | in | *Questionable Content*, *Security Risks*, *Miscellaneous* | Block |

* API

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "name": "All-DNS-ContentCategories-Blocklist",
      "description": "Block common content categories that may pose a risk",
      "precedence": 30,
      "enabled": true,
      "action": "block",
      "filters": [
          "dns"
      ],
      "traffic": "any(dns.content_category[*] in {17 85 87 102 157 135 138 180 162 32 169 177 128 15 115 119 124 141 161})",
      "identity": ""
    }'
  ```

* Terraform

  ```tf
  resource "cloudflare_zero_trust_gateway_policy" "block_content_categories" {
    account_id  = var.cloudflare_account_id
    name        = "All-DNS-ContentCategories-Blocklist"
    description = "Block common content categories that may pose a risk"
    enabled     = true
    action      = "block"
    filters     = ["dns"]
    traffic     = "any(dns.content_category[*] in {17 85 87 102 157 135 138 180 162 32 169 177 128 15 115 119 124 141 161})"
    identity    = ""
  }
  ```

## All-DNS-Application-Blocklist

Block unauthorized applications to limit your users' access to certain web-based tools and minimize the risk of [shadow IT](https://www.cloudflare.com/learning/access-management/what-is-shadow-it/). For example, the following policy blocks known AI tools:

* Dashboard

  | Selector | Operator | Value | Action |
  | - | - | - | - |
  | Application | in | *Artificial Intelligence* | Block |

* API

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "name": "All-DNS-Application-Blocklist",
      "description": "Block access to unauthorized AI applications",
      "precedence": 40,
      "enabled": true,
      "action": "block",
      "filters": [
          "dns"
      ],
      "traffic": "any(app.type.ids[*] in {25})",
      "identity": ""
    }'
  ```

* Terraform

  ```tf
  resource "cloudflare_zero_trust_gateway_policy" "block_unauthorized_apps" {
    account_id  = var.cloudflare_account_id
    name        = "All-DNS-Application-Blocklist"
    description = "Block access to unauthorized AI applications"
    enabled     = true
    action      = "block"
    filters     = ["dns"]
    traffic     = "any(app.type.ids[*] in {25})"
    identity    = ""
  }
  ```

## All-DNS-GeoCountryIP-Blocklist

Block websites hosted in countries categorized as high risk. The designation of such countries may result from your organization's users or through the implementation of regulations including [EAR](https://www.tradecompliance.pitt.edu/embargoed-and-sanctioned-countries), [OFAC](https://orpa.princeton.edu/export-controls/sanctioned-countries), and [ITAR](https://www.tradecompliance.pitt.edu/embargoed-and-sanctioned-countries).

* Dashboard

  | Selector | Operator | Value | Action |
  | - | - | - | - |
  | Resolved Country IP Geolocation | in | *Afghanistan*, *Belarus*, *Congo (Kinshasa)*, *Cuba*, *Iran*, *Iraq*, *Korea (North)*, *Myanmar*, *Russian Federation*, *Sudan*, *Syria*, *Ukraine*, *Zimbabwe* | Block |

* API

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "name": "All-DNS-GeoCountryIP-Blocklist",
      "description": "Block traffic hosted in countries categorized as high security risks",
      "precedence": 50,
      "enabled": true,
      "action": "block",
      "filters": [
          "dns"
      ],
      "traffic": "any(dns.dst.geo.country[*] in {\"AF\" \"BY\" \"CD\" \"CU\" \"IR\" \"IQ\" \"KP\" \"MM\" \"RU\" \"SD\" \"SY\" \"UA\" \"ZW\"})"
    }'
  ```

* Terraform

  ```tf
  resource "cloudflare_zero_trust_gateway_policy" "dns_geolocation_block_policy" {
    account_id  = var.cloudflare_account_id
    name        = "All-DNS-GeoCountryIP-Blocklist"
    description = "Block traffic hosted in countries categorized as high security risks"
    precedence  = 50
    enabled     = true
    action      = "block"
    filters     = ["dns"]
    traffic     = "any(dns.dst.geo.country[*] in {\"AF\" \"BY\" \"CD\" \"CU\" \"IR\" \"IQ\" \"KP\" \"MM\" \"RU\" \"SD\" \"SY\" \"UA\" \"ZW\"})"
  }
  ```

## All-DNS-DomainTopLevel-Blocklist

Block frequently misused top-level domains (TLDs) to reduce security risks, especially when there is no discernible advantage to be gained from allowing access. Similarly, restricting access to specific country-level TLDs may be necessary to comply with regulations such as [OFAC](https://orpa.princeton.edu/export-controls/sanctioned-countries) and [ITAR](https://www.tradecompliance.pitt.edu/embargoed-and-sanctioned-countries).

* Dashboard

  | Selector | Operator | Value | Action |
  | - | - | - | - |
  | Domain | matches regex | `[.](cn\|ru)$ or [.](rest\|hair\|top\|live\|cfd\|boats\|beauty\|mom\|skin\|okinawa)$ or [.](zip\|mobi)$` | Block |

* API

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "name": "All-DNS-DomainTopLevel-Blocklist",
      "description": "Block DNS queries of known risky TLDs",
      "precedence": 60,
      "enabled": true,
      "action": "block",
      "filters": [
          "dns"
      ],
      "traffic": "any(dns.domains[*] matches \".$ or .$ or .$\")"
    }'
  ```

* Terraform

  ```tf
  resource "cloudflare_zero_trust_gateway_policy" "dns_blacklist_policy" {
    account_id  = var.cloudflare_account_id
    name        = "All-DNS-DomainTopLevel-Blocklist"
    description = "Block DNS queries of known risky TLDs"
    precedence  = 60
    enabled     = true
    action      = "block"
    filters     = ["dns"]
    traffic     = "any(dns.domains[*] matches \"[.](cn|ru)$ or [.](rest|hair|top|live|cfd|boats|beauty|mom|skin|okinawa)$ or [.](zip|mobi)$\")"
  }
  ```

## All-DNS-DomainPhishing-Blocklist

Block misused domains to protect your users against sophisticated phishing attacks, such as domains that specifically target your organization. For example, the following policy blocks specific keywords associated with an organization or its authentication services (such as `okta`, `2fa`, `cloudflare` and `sso`) while still allowing access to known domains.

* Dashboard

  | Selector | Operator | Value | Logic | Action |
  | - | - | - | - | - |
  | Domain | not in list | *Known Domains* | And | Block |
  | Domain | matches regex | `.*okta.*\|.*cloudflare.*\|.*mfa.*\|.sso.*` | | |

* API

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "name": "All-DNS-DomainPhishing-Blocklist",
      "description": "Block misused domains used in phishing campaigns",
      "precedence": 70,
      "enabled": true,
      "action": "block",
      "filters": [
          "dns"
      ],
      "traffic": "any(dns.domains[] matches \".okta.|.cloudflare.|.mfa.|.sso.\") and not(any(dns.domains[*] in $<KNOWN_DOMAINS_LIST_UUID>))"
    }'
  ```

* Terraform

  ```tf
  resource "cloudflare_zero_trust_gateway_policy" "dns_phishing_domains_block" {
    account_id  = var.cloudflare_account_id
    name        = "All-DNS-DomainPhishing-Blocklist"
    description = "Block misused domains used in phishing campaigns"
    precedence  = 70
    enabled     = true
    action      = "block"
    filters     = ["dns"]
    traffic     = "any(dns.domains[*] matches \".*okta.*|.*cloudflare.*|.*mfa.*|.sso.*\") and not(any(dns.domains[*] in ${"$"}${cloudflare_zero_trust_list.known_phishing_domains_list.id}))"
  }
  ```

## All-DNS-ResolvedIP-Blocklist

Block specific IP addresses that are malicious or pose a threat to your organization.

You can implement this policy by either creating custom blocklists or by using blocklists provided by threat intelligence partners or regional Computer Emergency and Response Teams (CERTs). Ideally, your CERTs can update the blocklist with an [API automation](https://developers.cloudflare.com/security-center/intel-apis/) to provide real-time threat protection.

* Dashboard

  | Selector | Operator | Value | Action |
  | - | - | - | - |
  | Resolved IP | in list | *IP Blocklist* | Block |

* API

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "name": "All-DNS-ResolvedIP-Blocklist",
      "description": "Block specific IP addresses deemed to be a risk to the Organization",
      "precedence": 80,
      "enabled": true,
      "action": "block",
      "filters": [
          "dns"
      ],
      "traffic": "any(dns.resolved_ips[*] in $<IP_BLOCKLIST_UUID>)"
    }'
  ```

* Terraform

  ```tf
  resource "cloudflare_zero_trust_gateway_policy" "dns_resolvedip_blocklist_rule" {
    account_id  = var.cloudflare_account_id
    name        = "All-DNS-ResolvedIP-Blocklist"
    description = "Block specific IP addresses deemed to be a risk to the Organization"
    precedence  = 80
    enabled     = true
    action      = "block"
    filters     = ["dns"]
    traffic     = "any(dns.resolved_ips[*] in ${"$"}${cloudflare_zero_trust_list.ip_blocklist.id}"
  }
  ```

## All-DNS-DomainHost-Blocklist

Block specific domains or hosts that are malicious or pose a threat to your organization. Like **All-DNS-ResolvedIP-Blocklist**, this blocklist can be updated manually or via API automation.

* Dashboard

  | Selector | Operator | Value | Logic | Action |
  | - | - | - | - | - |
  | Domain | in list | *Domain Blocklist* | Or | Block |
  | Host | in list | *Host Blocklist* | Or | |
  | Host | matches regex | `.*example\.com` | | |

* API

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "name": "All-DNS-DomainHost-Blocklist",
      "description": "Block specific domains or hosts that are malicious or pose a threat to your organization.",
      "precedence": 90,
      "enabled": true,
      "action": "block",
      "filters": [
          "dns"
      ],
      "traffic": "any(dns.domains[*] in $<DOMAIN_BLOCKLIST_UUID>) and dns.fqdn in $<HOST_BLOCKLIST_UUID> and dns.fqdn matches \".*example.com\""
    }'
  ```

* Terraform

  ```tf
  resource "cloudflare_zero_trust_gateway_policy" "block_dns_domain_host" {
    account_id  = var.cloudflare_account_id
    name        = "All-DNS-DomainHost-Blocklist"
    description = "Block specific domains or hosts that are malicious or pose a threat to your organization."
    precedence  = 90
    enabled     = true
    action      = "block"
    filters     = ["dns"]
    traffic     = "any(dns.domains[*] in ${"$"}${cloudflare_zero_trust_list.domain_blocklist.id}) and dns.fqdn in ${"$"}${cloudflare_zero_trust_list.host_blocklist.id} and dns.fqdn matches \".*example\\.com\""
  }
  ```
