---
title: Load balancing analytics · Cloudflare Load Balancing docs
description: Use load balancing analytics to evaluate traffic flow, assess the
  health of endpoints, and review health changes over time.
lastUpdated: 2025-05-14T00:02:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/load-balancing/reference/load-balancing-analytics/
  md: https://developers.cloudflare.com/load-balancing/reference/load-balancing-analytics/index.md
---

Using load balancing analytics, you can:

* Evaluate traffic flow.
* Assess the health status of endpoints in your pools.
* Review changes in pools and pool health over time.

Note

Load balancing analytics are only available to customers on paid plans (Pro, Business, and Enterprise).

## Dashboard Analytics

### Overview metrics

To view **Overview** metrics for your load balancer, go to **Traffic** > **Load Balancing Analytics**.

These metrics show the number of requests routed to specific pools within a load balancer, helping you:

* Evaluate the effects of adding or removing a pool.
* Decide when to create new pools.
* Plan for peak traffic demands and future infrastructure needs.

Add additional filters for specific pools, times, regions, and endpoints.

Note

Load balancing **requests** are the number of uncached requests made by your load balancer. By default, Cloudflare caches resolved IP addresses for up to five seconds.

### Latency

**Latency** metrics show an interactive map, helping you identify regions with **Unhealthy** or **Slow** pools.

To view latency information for your load balancer, go to **Traffic** > **Load Balancing Analytics** > **Latency**.

### Logs

**Logs** provide a history of all endpoint status changes and how they affect your load balancing pools. Load Balancing only logs events that represent a status change for an endpoint, from healthy to unhealthy or vice versa.

To access logs in the dashboard, go to **Traffic** > **Load Balancing Analytics**.

## GraphQL Analytics

For more flexibility, get load balancing metrics directly from the [GraphQL Analytics API](https://developers.cloudflare.com/analytics/graphql-api/).

Get started with a sample query:

Requests per pool

This query shows the number of requests each pool receives from each location in Cloudflare's global network.

```graphql
query RequestsPerPool($zoneTag: string, $start: Time, $end: Time) {
  viewer {
    zones(filter: { zoneTag: $zoneTag }) {
      loadBalancingRequestsAdaptiveGroups(
        limit: 100
        filter: {
          datetime_geq: $start
          datetime_leq: $end
          lbName: "lb.example.com"
        }
        orderBy: [datetimeFifteenMinutes_DESC]
      ) {
        count
        dimensions {
          datetimeFifteenMinutes
          coloCode
          selectedPoolName
        }
      }
    }
  }
}
```

[Run in GraphQL API Explorer](https://graphql.cloudflare.com/explorer?query=I4VwpgTgngBASmUYDOAXZAFSGD2OA2AFACQBeOAdmACoCGA5gFwxoQCWF9ANDMWrRFTNqbALZgexMBQAmwsWACUMAN4AoGDABubMAHdIqjZpjkqyQgDM2+VJGYrTlGg2ZlndejAC+y9SZN8HFoZACFafFoKAGMOegQkNGQAQRlaAAdUNi0wAHEIHBB0i2MAzXwxNiEYAEYABjrSsutbeyMysrS7LPEAfXpEN35BJo6usB6wXvxB3mkZUbL8ACMAOVpxZgAiFYA6MAAPDfSZ3eicUS3FzW9rmBwIGUhQqGYAbXHJgDE2SztpACyHBAdmQvQAIgBRADKAGEALqLPx3c4gCioO4yBQUZBsSjIdodEyfBQ-P5gQHA0F3TTnIKwnBPGksMAzaJ2GS4AjrcR3W4dfkmQW3bxAA\&variables=N4IgXg9gdgpgKgQwOYgFwgFoHkByBRAfQEkAREAGhAGcAXBAJxrRACYAGFgVgFoBGNvpzi8A7KgDMATlScAHBgogYUACbN2XPgN5CW4idLkKAvkA)

```json
{
    "data": {
        "viewer": {
            "zones": [
                {
                    "loadBalancingRequestsAdaptiveGroups": [
                        {
                            "count": 4,
                            "dimensions": {
                                "coloCode": "IAD",
                                "datetimeFifteenMinutes": "2021-06-26T00:45:00Z",
                                "selectedPoolName": "us-east"
                            }
                        },
                        ...
                    ]
                }
            ]
        }
    }
}
```

Requests per data center

This query shows the weighted, round-trip time (RTT) measurement (`avgRttMs`) for monitor requests from a specific data center (for example, Singapore or `SIN`) to each pool in a specific load balancer.

Warning

Note that `avgRttMs` refers to the round-trip time that is measured by the monitors and used in steering decisions. `avgRttMs` is different from the raw RTT for individual requests that reach the Cloudflare network.

```graphql
query RequestsPerDataCenter($zoneTag: string, $start: Time, $end: Time) {
  viewer {
    zones(filter: { zoneTag: $zoneTag }) {
      loadBalancingRequestsAdaptive(
        limit: 100
        filter: {
          datetime_geq: $start
          datetime_leq: $end
          lbName: "lb.example.com"
          coloCode: "SIN"
        }
        orderBy: [datetime_DESC]
      ) {
        selectedPoolName
        pools {
          poolName
          healthy
          healthCheckEnabled
          avgRttMs
        }
      }
    }
  }
}
```

[Run in GraphQL API Explorer](https://graphql.cloudflare.com/explorer?query=I4VwpgTgngBASmUYDOAXZAFSARAhq3AYTADtVIAKAEgC8B7EsAFVwHMAuGNCASxNYA0MKmlwRUnJjwC2YIVVIATSTLABKGAG8AUDBgA3HmADukLbr0x6jZBQBmPADbkInTVYbM2nWp5asYAF8NHUtLRzpcRQAhXEdcEgBjPlYEJDRkAEFFXAAHVB59MAoLML1HGR4JGABGAAY60rKHZ0g3JrKYHPIC2QB9VkQfUXEOsu6wXrA+xyHhJTGwxwAjADlcWU4AIhWAOjAADw3c2d3EumktxctziMI6RTBtgGUASVWrzr1A67oIR4g0SgnAA2hMpn1sABRZ6EAC6YxC12QYFmiXIigwdDojnWsmuuWxjmQ5i+lkJOLxYGuegAFmA4qhaVAaTB6YzaYR6YkANZQki4ZazRSs3D6VKoVAAWWQ1x+nXllkVP0CQA\&variables=N4IgXg9gdgpgKgQwOYgFwgFoHkByBRAfQEkAREAGhAGcAXBAJxrRACYAGFgVgFoBGNvpzi8A7KgDMATlScAHBgogYUACbN2XPgN5CW4idLkKAvkA)

```json
{
    "data": {
        "viewer": {
            "zones": [
                {
                    "loadBalancingRequestsAdaptive": [
                        {
                            "pools": [
                                {
                                    "avgRttMs": 67,
                                    "healthCheckEnabled": 1,
                                    "healthy": 1,
                                    "poolName": "asia-ne"
                                },
                                {
                                    "avgRttMs": 156,
                                    "healthCheckEnabled": 1,
                                    "healthy": 1,
                                    "poolName": "us-east_and_asia-ne"
                                },
                                {
                                    "avgRttMs": 237,
                                    "healthCheckEnabled": 1,
                                    "healthy": 1,
                                    "poolName": "us-east"
                                },
                            ],
                            "selectedPoolName": "asia-ne"
                        },
                    ...
                    ]
                }
            ]
        }
    }
}
```
