---
title: Magic WAN site analytics · Cloudflare Magic WAN docs
description: After adding your sites, the Network overview (beta) section of the
  dashboard provides a summary of the connectivity status and traffic analytics
  for all your sites. This is a great place to start if you receive a Magic WAN
  alert, need to begin the troubleshooting process, or are performing routine
  monitoring. Refer to Set up a site for more information on how to set up a
  site.
lastUpdated: 2025-10-15T16:28:04.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-wan/analytics/site-analytics/
  md: https://developers.cloudflare.com/magic-wan/analytics/site-analytics/index.md
---

After adding your sites, the Network overview (beta) section of the dashboard provides a summary of the connectivity status and traffic analytics for all your sites. This is a great place to start if you receive a Magic WAN alert, need to begin the troubleshooting process, or are performing routine monitoring. Refer to [Set up a site](https://developers.cloudflare.com/magic-wan/configuration/common-settings/sites/) for more information on how to set up a site.

Network overview (beta) has the following data types available:

Geographic map summary

* [Aggregate Magic WAN site health](#site-health)
* [Magic WAN availability status for sites](#no-status-available)
* [Magic WAN site geographic location](#no-location-set)

Magic WAN site data table

* Site Name
* Site Health
* Site Tunnel Names
* Site Tunnel Statuses
* Site Traffic Sent
* Site Traffic Received

Magic WAN site data

* Traffic Sent by Tunnel
* Traffic Received by Tunnel

To start using Magic WAN site analytics:

1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/) and select your account.
2. Select **Magic WAN** > **Network overview (beta)**.

You will have access to an overview map with all your active sites, and any alerts for sites that are unhealthy or have no status available to them.

Review the topics below to learn more about the options available to you.

### Network map and traffic overview

The network map section shows all the sites configured with Magic WAN. At a glance, you can check:

* How many active sites you have
* Location for sites in a map (if you set up their geographic location)
* Sites that are healthy or unhealthy
* Sites that have no status available
* Sites that have no location set

Just below the map, Traffic overview shows a more granular list of your sites and their status.

#### Site health

Sites can be healthy or unhealthy, and Magic WAN uses this information to route traffic. Refer to [Set thresholds for site health](#set-thresholds-for-site-health) to learn more about this topic.

#### No status available

The status of a site refers to its health. If your sites show a **No status available** message, this means you did not configure your alert settings when creating your site. Refer to [Configure Magic Tunnel health alerts](https://developers.cloudflare.com/magic-wan/configuration/common-settings/configure-magic-tunnel-health-alerts/) to learn how to create an alert for your site.

#### No location set

The dashboard shows you the number of sites with no location set, meaning sites for which you did not set up a geographic location. To add a location to a site, find the site you want to add location to, and select **no location set** to edit its location settings. Refer to [Set geographic coordinates](https://developers.cloudflare.com/magic-wan/configuration/common-settings/sites/#set-geographic-coordinates) for more information.

### Traffic overview

Traffic overview aggregates all Magic WAN sites configured in your account. Here, you can check at-a-glance information about each site like:

* Site status
* Traffic sent and received

Select one of your sites to have access to a more detailed view of its traffic, including traffic by tunnel.

### Set thresholds for site health

When you set up an alert for your site, you will be notified when there is an issue with one or more on-ramps. These alerts are sent when the percentage of successful health checks for a Magic WAN on-ramp drops below the selected service-level objective (SLO). Setting health alerts will also show unhealthy tunnels in the Network map and in the Traffic overview sections.

To set up health alerts:

1. Configure [Magic Tunnel health alerts](https://developers.cloudflare.com/magic-wan/configuration/common-settings/configure-magic-tunnel-health-alerts/) across all of the Magic Tunnels associated with each Magic WAN site.
2. After configuring Magic Tunnel health alerts, any Magic WAN site with a Magic Tunnel (on-ramp) that is outside of its SLO threshold will be labeled unhealthy in Network map and Traffic overview.
