---
title: Configuration Rules settings · Cloudflare Rules docs
description: You can change the configuration settings described below in a
  configuration rule.
lastUpdated: 2025-09-16T10:23:03.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/configuration-rules/settings/
  md: https://developers.cloudflare.com/rules/configuration-rules/settings/index.md
---

You can change the configuration settings described below in a configuration rule.

## Automatic HTTPS Rewrites

[Automatic HTTPS Rewrites](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/automatic-https-rewrites/) prevents end users from seeing `Mixed content` errors by rewriting URLs from `http` to `https` for resources or links on your website that can be served with HTTPS.

Use this setting to turn on or off Automatic HTTPS Rewrites for matching requests.

API information

API configuration property name: `"automatic_https_rewrites"` (boolean).

```json
"action_parameters": {
  "automatic_https_rewrites": true
}
```

Refer to [Create a configuration rule via API](https://developers.cloudflare.com/rules/configuration-rules/create-api/#example-requests) for complete API examples.

## Browser Integrity Check

[Browser Integrity Check](https://developers.cloudflare.com/waf/tools/browser-integrity-check/) blocks access to pages based on specific HTTP headers commonly abused by spammers.

Use this setting to turn on or off Browser Integrity Check for matching requests.

API information

API configuration property name: `"bic"` (boolean).

```json
"action_parameters": {
  "bic": true
}
```

Refer to [Create a configuration rule via API](https://developers.cloudflare.com/rules/configuration-rules/create-api/#example-requests) for complete API examples.

## Disable Real User Monitoring (RUM)

[Cloudflare Web Analytics](https://developers.cloudflare.com/web-analytics/), also known as Real User Monitoring (RUM), is Cloudflare's free, privacy-first analytics for your website.

Use this setting to turn off Web Analytics for matching requests.

Warning

Configuration rules have precedence over any Web Analytics rules. If a Web Analytics rule turns on analytics measurements for an incoming request and the same request matches a configuration rule turning off Web Analytics, the configuration rule will win.

API information

API configuration property name: `"disable_rum"` (boolean).

```json
"action_parameters": {
  "disable_rum": true
}
```

Refer to [Create a configuration rule via API](https://developers.cloudflare.com/rules/configuration-rules/create-api/#example-requests) for complete API examples.

## Disable Zaraz

[Cloudflare Zaraz](https://developers.cloudflare.com/zaraz/) gives you complete control over third-party tools and services for your website, and allows you to offload them to the Cloudflare global network.

Use this setting to turn off Zaraz for matching requests.

API information

API configuration property name: `"disable_zaraz"` (boolean).

```json
"action_parameters": {
  "disable_zaraz": true
}
```

Refer to [Create a configuration rule via API](https://developers.cloudflare.com/rules/configuration-rules/create-api/#example-requests) for complete API examples.

## Hotlink Protection

[Hotlink Protection](https://developers.cloudflare.com/waf/tools/scrape-shield/hotlink-protection/) prevents your images from being used by other sites, potentially reducing the bandwidth consumed by your origin server.

Use this setting to turn on or off Hotlink Protection for matching requests.

API information

API configuration property name: `"hotlink_protection"` (boolean).

```json
"action_parameters": {
    "hotlink_protection": false
}
```

Refer to [Create a configuration rule via API](https://developers.cloudflare.com/rules/configuration-rules/create-api/#example-requests) for complete API examples.

## Email Obfuscation

[Email Obfuscation](https://developers.cloudflare.com/waf/tools/scrape-shield/email-address-obfuscation/) helps in spam prevention by hiding email addresses appearing in your pages from email harvesters and other bots, while remaining visible to your site visitors.

Use this setting to turn on or off Email Obfuscation for matching requests.

API information

API configuration property name: `"email_obfuscation"` (boolean).

```json
"action_parameters": {
  "email_obfuscation": false
}
```

Refer to [Create a configuration rule via API](https://developers.cloudflare.com/rules/configuration-rules/create-api/#example-requests) for complete API examples.

## Fonts

[Cloudflare Fonts](https://developers.cloudflare.com/speed/optimization/content/fonts/) rewrites Google Fonts to be delivered from a website's own origin, eliminating the need to rely on third-party font providers.

Use this setting to turn on or off Cloudflare Fonts for matching requests.

API information

API configuration property name: `"fonts"` (boolean).

```json
"action_parameters": {
  "fonts": false
}
```

Refer to [Create a configuration rule via API](https://developers.cloudflare.com/rules/configuration-rules/create-api/#example-requests) for complete API examples.

## Mirage

Deprecation notice

Mirage was deprecated on September 15, 2025.

[Mirage](https://developers.cloudflare.com/speed/optimization/images/mirage/) accelerates image delivery for your visitors based on their device.

Use this setting to turn on or off Mirage for matching requests.

API information

API configuration property name: `"mirage"` (boolean).

```json
"action_parameters": {
  "mirage": false
}
```

Refer to [Create a configuration rule via API](https://developers.cloudflare.com/rules/configuration-rules/create-api/#example-requests) for complete API examples.

## Opportunistic Encryption

[Opportunistic Encryption](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/opportunistic-encryption/) allows browsers to access HTTP URIs over an encrypted TLS channel.

Use this setting to turn on or off Opportunistic Encryption for matching requests.

API information

API configuration property name: `"opportunistic_encryption"` (boolean).

```json
"action_parameters": {
  "opportunistic_encryption": true
}
```

Refer to [Create a configuration rule via API](https://developers.cloudflare.com/rules/configuration-rules/create-api/#example-requests) for complete API examples.

## Polish

[Cloudflare Polish](https://developers.cloudflare.com/images/polish/) is a one-click image optimization product that automatically optimizes images in your site.

Use this setting to configure Polish for matching requests:

* Off
* Lossless
* Lossy
* WebP

Refer to [Compression options](https://developers.cloudflare.com/images/polish/compression/#compression-options) for more information on these values.

API information

API configuration property name: `"polish"` (string).

API values: `"off"`, `"lossless"`, `"lossy"`, `"webp"`.

```json
"action_parameters": {
  "polish": "webp"
}
```

Refer to [Create a configuration rule via API](https://developers.cloudflare.com/rules/configuration-rules/create-api/#example-requests) for complete API examples.

## Rocket Loader

[Rocket Loader](https://developers.cloudflare.com/speed/optimization/content/rocket-loader/) prioritizes your website's content (such as text, images, and fonts) by deferring the loading of all your JavaScript code until after rendering.

Use this setting to turn on or off Rocket Loader for matching requests.

API information

API configuration property name: `"rocket_loader"` (boolean).

```json
"action_parameters": {
  "rocket_loader": true
}
```

Refer to [Create a configuration rule via API](https://developers.cloudflare.com/rules/configuration-rules/create-api/#example-requests) for complete API examples.

## I'm Under Attack

When enabled, [Under Attack mode](https://developers.cloudflare.com/fundamentals/reference/under-attack-mode/) performs additional security checks to help mitigate layer 7 DDoS attacks. Validated users access your website and suspicious traffic is blocked.

Use this setting to turn on or off Under Attack mode for matching requests.

API information

API configuration property name: `"security_level"` (string).

API values: `"off"`, `"essentially_off"`, `"under_attack"`.

```json
"action_parameters": {
  "security_level": "under_attack"
}
```

Refer to [Create a configuration rule via API](https://developers.cloudflare.com/rules/configuration-rules/create-api/#example-requests) for complete API examples.

## SSL

[SSL/TLS encryption modes](https://developers.cloudflare.com/ssl/origin-configuration/ssl-modes/) control the scheme (`http://` or `https://`) that Cloudflare uses to connect to your origin web server and how SSL certificates presented by your origin will be validated.

Use this setting to configure the SSL/TLS encryption mode for matching requests:

* Off
* Flexible
* Full
* Strict
* Origin Pull

Refer to [Available encryption modes](https://developers.cloudflare.com/ssl/origin-configuration/ssl-modes/#available-encryption-modes) for more information on these values.

API information

API configuration property name: `"ssl"` (string).

API values: `"off"`, `"flexible"`, `"full"`, `"strict"`, `"origin_pull"`.

```json
"action_parameters": {
  "ssl": "flexible"
}
```

Refer to [Create a configuration rule via API](https://developers.cloudflare.com/rules/configuration-rules/create-api/#example-requests) for complete API examples.

## SXG

[Signed Exchanges (SXG)](https://developers.cloudflare.com/speed/optimization/other/signed-exchanges/) is an open standard that makes it possible to cryptographically authenticate the origin of a resource independently of how it is delivered.

Use this setting to turn on or off signed exchanges for matching requests.

API information

API configuration property name: `"sxg"` (boolean).

```json
"action_parameters": {
  "sxg": false
}
```

Refer to [Create a configuration rule via API](https://developers.cloudflare.com/rules/configuration-rules/create-api/#example-requests) for complete API examples.

Deprecation notice

Signed exchanges is being deprecated and will be removed on October 20, 2025.
