---
title: Phases · Cloudflare Ruleset Engine docs
description: A phase defines a stage in the life of a request where you can
  execute rulesets. Phases are defined by Cloudflare and cannot be modified.
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ruleset-engine/about/phases/
  md: https://developers.cloudflare.com/ruleset-engine/about/phases/index.md
---

A phase defines a stage in the life of a request where you can execute rulesets. Phases are defined by Cloudflare and cannot be modified.

Phases exist at two levels: at the **account** level and at the **zone** level. For the same phase, rules defined at the account level are evaluated **before** the rules defined at the zone level.

Each phase has at most one [entry point ruleset](https://developers.cloudflare.com/ruleset-engine/about/rulesets/#entry-point-ruleset) at the account and zone level.

Note

Currently, phases at the account level are only available in Enterprise plans.

The following diagram outlines the request handling process where requests go through the available phases:

![Diagram showing the request handling process. The user request goes through several request phases until it eventually reaches the origin server (the request can also be blocked). The origin returns a response, which goes through several response phases until it reaches the user.](https://developers.cloudflare.com/_astro/rulesets-phases.D4jji4ui_14HM7e.webp)

Cloudflare products are specific to one or more phases, and they add support for different features. Check the documentation for each Cloudflare product for details on the applicable phases.

Refer to [Phases list](https://developers.cloudflare.com/ruleset-engine/reference/phases-list/) for a list of phases and their corresponding Cloudflare products.
