---
title: http.response.content_type.media_type · Cloudflare Ruleset Engine docs
description: The lowercased content type (including subtype and suffix) without
  any extra parameters, based on the response's `Content-Type` header.
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.response.content_type.media_type/
  md: https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.response.content_type.media_type/index.md
---

# http.response.content\_type.media\_type

`http.response.content_type.media_type` String

The lowercased content type (including subtype and suffix) without any extra parameters, based on the response's `Content-Type` header.

The field value will not include parameters such as `charset`.

Example values:

| Content-Type header | Field value |
| - | - |
| `text/html` | `"text/html"` |
| `text/html; charset=utf-8` | `"text/html"` |
| `text/html+extra` | `"text/html+extra"` |
| `text/html+extra; charset=utf-8` | `"text/html+extra"` |
| `text/HTML` | `"text/html"` |
| `text/html; charset=utf-8; other=value` | `"text/html"` |

Categories:

* Response
* Headers
