---
title: Investigate threats · Cloudflare Security Center docs
description: Users can investigate the details of an IP address, domain name,
  URL, or Autonomous System Number (ASN). You can find the Investigate feature
  in your Cloudflare account's Security Center and in Cloudflare Radar.
lastUpdated: 2025-09-03T13:18:17.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/security-center/investigate/investigate-threats/
  md: https://developers.cloudflare.com/security-center/investigate/investigate-threats/index.md
---

Users can investigate the details of an IP address, domain name, URL, or Autonomous System Number (ASN). You can find the Investigate feature in your Cloudflare account's Security Center and in [Cloudflare Radar](https://radar.cloudflare.com/scan).

You can search with Investigate by [IP address](https://developers.cloudflare.com/security-center/investigate/investigate-threats/#ip-address), [domain](https://developers.cloudflare.com/security-center/investigate/investigate-threats/#domain), [URL](https://developers.cloudflare.com/security-center/investigate/investigate-threats/#url) and [AS number](https://developers.cloudflare.com/security-center/investigate/investigate-threats/#as-number).

Note

Search methods are also available through the [API](https://developers.cloudflare.com/security-center/intel-apis/).

## IP Address

An [IP address](https://www.cloudflare.com/learning/dns/glossary/what-is-my-ip-address/) is a unique address that identifies a server. It stands for [Internet Protocol](https://www.cloudflare.com/learning/network-layer/internet-protocol/), which is the set of rules that allows servers to communicate with each other.

IP address search allows you to search both [IPv4 and IPv6](https://www.cloudflare.com/learning/dns/glossary/what-is-my-ip-address/) addresses and retrieve relevant information such as their pointer records, AS numbers and passive DNS records.

## Domain

A [domain name](https://www.cloudflare.com/learning/dns/glossary/what-is-a-domain-name/) is a string of text that maps to an IP address. Domain names are used to help people remember where websites are hosted. Domain names are purchased through [registrars](https://developers.cloudflare.com/registrar/) and can be acquired easily by anyone.

When you search for a domain name, Cloudflare will provide an overview of the domain's [category](#domain-categories) and IP addresses it currently resolves to.

### Domain categories

For a detailed list of categories, refer to [Domain categories](https://developers.cloudflare.com/cloudflare-one/policies/gateway/domain-categories/).

A domain can have multiple categories. Cloudflare displays both the parent category and the detailed child category. You can [request category changes](https://developers.cloudflare.com/security-center/investigate/change-categorization/) for a domain. Miscategorized domains can also request to have a category added. This request goes through an approval process with the Cloudflare team.

As part of the domain search results, Cloudflare show the WHOIS details and a history of its category changes over time.

## AS Number

An [AS number](https://www.cloudflare.com/learning/network-layer/what-is-an-autonomous-system/) is a group of IP addresses belonging to and controlled by a single organization. The entire group of networks have a single unified routing policy. The [Internet Assigned Numbers Authority](https://www.iana.org/) (IANA) is the organization responsible for managing the assignment and distribution of AS numbers. The AS number's routing policies are used by [BGP](https://www.cloudflare.com/learning/security/glossary/what-is-bgp/) which is how Cloudflare's [anycast network](https://www.cloudflare.com/learning/cdn/glossary/anycast-network/) works.

When you search for an AS number, Cloudflare will return registration data such as its country, description and type. It will also display data such as domain count, top 10 domains and subnets.

With sufficient data, AS number search results will also return the geographical distribution of traffic in its network, application level attacks and network level attacks, each broken down by Cloudflare mitigation techniques and network protocols, respectively.

## Hash

When you search for a hash, the Cloudflare dashboard will provide a URL report for that specific hash.

To search using a hash:

1. In the Cloudflare dashboard, go to the **Investigate** page.

   [Go to **Investigate**](https://dash.cloudflare.com/?to=/:account/security-center/investigate)

2. Enter the hash, then select **Search**.

3. Select **View report** to view the report for your URL.

## URL

When you search for a URL, Cloudflare will provide a list of recent scan reports for that specific URL, limited to the past 30 days. You can view previously generated reports or scan again to generate a new report.

Different Cloudflare plans will have different [scan limitations](https://developers.cloudflare.com/security-center/investigate/scan-limits/).

If you want to scan a URL:

1. In the Cloudflare dashboard, go to the **Investigate** page.

   [Go to **Investigate**](https://dash.cloudflare.com/?to=/:account/security-center/investigate)

2. Enter the URL, then select **Search**.

Alternatively, to scan a URL, go to [Cloudflare Radar](https://radar.cloudflare.com/) > **URL scanner**. Enter the URL, then select **Publish**.

Note

You can use [Cloudflare Radar API](https://developers.cloudflare.com/radar/investigate/url-scanner/#use-the-api) to investigate threats.

### Visibility

When generating a new scan report, the default visibility is set to `Unlisted`, but you have the option to set it to `Public`. By choosing `Public`, the generated scan will be available to all Cloudflare dashboard and Cloudflare Radar users alike, which will increase awareness of potentially malicious websites for others.

We recommend choosing `Unlisted` if you are scanning infrastructure that is not intended to be shared with the wider Cloudflare community.

### Filters

While viewing the most recent scans, you can use the filtering options. Selecting `All account scans` will display both `Unlisted` or `Public` scans initiated from your Cloudflare account. However, by selecting `All global scans`, only `Public` scans are displayed.

### Downloads

You can download a report of your scan in HAR or JSON format.

To download a report:

1. In the Cloudflare dashboard, go to the **Investigate** page.

   [Go to **Investigate**](https://dash.cloudflare.com/?to=/:account/security-center/investigate)

2. Enter your domain and select **Search**.

3. Once the report has been generated, select **Download** and choose between **Download HAR** or **Download JSON**.
