---
title: Add CAA records · Cloudflare SSL/TLS docs
description: A Certificate Authority Authorization (CAA) DNS record specifies
  which certificate authorities (CAs) are allowed to issue certificates for a
  domain. This record reduces the chance of unauthorized certificate issuance
  and promotes standardization across your organization.
lastUpdated: 2025-08-20T18:47:44.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ssl/edge-certificates/caa-records/
  md: https://developers.cloudflare.com/ssl/edge-certificates/caa-records/index.md
---

A Certificate Authority Authorization (CAA) DNS record specifies which certificate authorities (CAs) are allowed to issue certificates for a domain. This record reduces the chance of unauthorized certificate issuance and promotes standardization across your organization.



For additional security, set up [Certificate Transparency Monitoring](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/certificate-transparency-monitoring/) as well.

Note

For more technical details about CAA records, refer to the [introductory blog post](https://blog.cloudflare.com/caa-of-the-wild/).

## Who should create CAA records?

You should [create CAA records](#create-caa-records) in Cloudflare if each of the following is true:

* You uploaded your own custom origin server certificate (not provisioned by Cloudflare).
* That certificate was issued by a CA (not self-signed).
* Your domain is on a full setup (not a [CNAME setup](https://developers.cloudflare.com/dns/zone-setups/partial-setup)).
* When adding new [Custom Hostname](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/start/getting-started/) and your customer has existing CAA records. In this case, ask your customer to remove the existing CAA records or add the missing CAA record.

## CAA records added by Cloudflare

Cloudflare adds CAA records automatically in two situations:

* When you have [Universal SSL](https://developers.cloudflare.com/ssl/edge-certificates/universal-ssl/) or [advanced certificates](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/) and add any CAA records to your zone.
* When you have [Universal SSL](https://developers.cloudflare.com/ssl/edge-certificates/universal-ssl/) enabled and enable [AMP Real URL](https://developers.cloudflare.com/speed/optimization/other/amp-real-url/) or [Signed exchanges (SXG)](https://developers.cloudflare.com/speed/optimization/other/signed-exchanges/).

Deprecation notice

AMP Real URL and Signed exchanges (SXG) are being deprecated and will be removed on October 20, 2025.

These records make sure Cloudflare can still issue Universal certificates on your behalf.

If Cloudflare has automatically added CAA records on your behalf, these records will not appear in the Cloudflare dashboard. However, if you run a command line query using `dig`, you can see any existing CAA records, including those added by Cloudflare (replacing `example.com` with your own domain on Cloudflare):

```bash
➜  ~ dig example.com caa +short


# CAA records added by Google Trust Services
0 issue "pki.goog; cansignhttpexchanges=yes"
0 issuewild "pki.goog; cansignhttpexchanges=yes"


# CAA records added by Let's Encrypt
0 issue "letsencrypt.org"
0 issuewild "letsencrypt.org"


# CAA records added by SSL.com
0 issue "ssl.com"
0 issuewild "ssl.com"


# CAA records added by Sectigo
0 issue "sectigo.com"
0 issuewild "sectigo.com"
```

## Create CAA records

Create a CAA record for each Certificate Authority (CA) that you plan to use for your domain.

* Dashboard

  To add a CAA record in the dashboard,

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com) and select your account and application.
  2. Go to **DNS** > **Records**.
  3. Select **Add record**.
  4. For **Type**, select **CAA**.
  5. For **Name**, type your domain.
  6. Choose a **Tag**, which specifies the behavior associated with the record.
  7. For **CA domain name**, enter the CA name.
  8. Select **Save**.
  9. Repeat for each CA associated with your domain.

* API

  To create a CAA record via the API, use this [POST endpoint](https://developers.cloudflare.com/api/resources/dns/subresources/records/methods/create/).

Once you have finished creating all the records, you can review them in the list of records appearing under the DNS Records panel.
