---
title: AI Tooling · Cloudflare Style Guide
description: Use the following AI tools to get the most out of Cloudflare (and our docs).
lastUpdated: 2025-10-15T15:19:18.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/ai-tooling/
  md: https://developers.cloudflare.com/style-guide/ai-tooling/index.md
---

Use the following AI tools to get the most out of Cloudflare (and our docs).

## llms.txt

We have implemented `llms.txt`, `llms-full.txt` and also created per-page Markdown links as follows:

* [`llms.txt`](https://developers.cloudflare.com/llms.txt)
* [`llms-full.txt`](https://developers.cloudflare.com/llms-full.txt)
  * We also provide a `llms-full.txt` file on a per-product basis, i.e [`/workers/llms-full.txt`](https://developers.cloudflare.com/workers/llms-full.txt)
* [`/$page/index.md`](index.md)
  * Add `/index.md` to the end of any page to get the Markdown version, i.e [`/style-guide/index.md`](https://developers.cloudflare.com/style-guide/index.md)
* [`/markdown.zip`](https://developers.cloudflare.com/markdown.zip)
  * An export of all of our documentation in the aforementioned `index.md` format.

In the top right of this page, you will see a `Page options` button where you can copy the current page as Markdown that can be given to your LLM of choice.

![Page options
button](https://developers.cloudflare.com/_astro/page-options.T2MlgPLy_1KQRmL.webp)

## MCP

Cloudflare runs a catalog of managed remote MCP Servers which you can connect to using OAuth on clients like [Claude](https://modelcontextprotocol.io/quickstart/user), [Windsurf](https://docs.windsurf.com/windsurf/cascade/mcp), our own [AI Playground](https://playground.ai.cloudflare.com/) or any [SDK that supports MCP](https://github.com/cloudflare/agents/tree/main/packages/agents/src/mcp).

* Cursor

  To install in Cursor, use this [Direct install link](https://cursor.com/en-US/install-mcp?name=cloudflare\&config=eyJjb21tYW5kIjoibnB4IG1jcC1yZW1vdGUgaHR0cHM6Ly9kb2NzLm1jcC5jbG91ZGZsYXJlLmNvbS9zc2UifQ%3D%3D).

* VSCode

  To install in VSCode, use this [Direct install link](vscode:mcp/install?%7B%22name%22%3A%22cloudflare%22%2C%22url%22%3A%22https%3A%2F%2Fdocs.mcp.cloudflare.com%2Fmcp%22%7D).

* Manually

  To install manually, add the following specification to your MCP config:

  ```json
    {
      "mcpServers": {
          "cloudflare": {
          "command": "npx",
          "args": ["mcp-remote", "https://docs.mcp.cloudflare.com/mcp"]
        }
      }
    }
  ```

Note

For other MCP servers offered by Cloudflare, refer to [Cloudflare's MCP servers](https://developers.cloudflare.com/agents/model-context-protocol/mcp-servers-for-cloudflare/).
