---
title: Product docs content strategy · Cloudflare Style Guide
description: "The purpose of Cloudflare's developer documentation content strategy is to:"
lastUpdated: 2025-07-15T13:59:35.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/documentation-content-strategy/
  md: https://developers.cloudflare.com/style-guide/documentation-content-strategy/index.md
---

The purpose of Cloudflare's developer documentation content strategy is to:

* Create and document standard templates to streamline content creation
* Document specific content types to help identify customers' specific needs
* Enable life cycle management to maintain and optimize a smaller set of pages
* Suggest easier navigation paths

Strategically speaking, the mission and guiding principles translate into the following initiatives:

* Improve the entire ecosystem of customer-facing product content, placing major emphasis on consistency, quality, accuracy, and timeliness
* Create a cohesive and compelling story around our products and their functionality
* Develop content that increases product adoption, deflects support, and makes customers successful
* Partner with various internal departments and stakeholders in creating and sustaining a rich, consistent content experience across all Cloudflare products
* Devise new and better ways to give users the information they need, when and where they need it

Adoption of this content strategy will be impacted by product releases, resourcing, and company goals.

## Purpose statements

For each purpose statement, the documentation team will define the approach to solve the content problem for a product.

This approach includes:

### Information architecture

* Where content should live on the site
* Linking strategy

### Content

* What content is included and what is optional
* How the content is written

## Content requirements

Content requirements help the contributor ensure they have answered the user question and have not lost the purpose of the content after moving into execution.

* [File conventions](https://developers.cloudflare.com/style-guide/documentation-content-strategy/file-conventions/)
* [Content types](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/)
* [Component attributes](https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/)
* [Information architecture](https://developers.cloudflare.com/style-guide/documentation-content-strategy/information-architecture/)
