---
title: Links · Cloudflare Style Guide
description: Follow these guidelines for link text.
lastUpdated: 2024-10-09T10:02:14.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/formatting/structure/links/
  md: https://developers.cloudflare.com/style-guide/formatting/structure/links/index.md
---

Follow these guidelines for link text.

## Create links

Use the path to the product when creating a link.

* **Do**:
  * `This is a link for Magic WAN's [Get started](/magic-wan/get-started/)`
* **Don't:**
  * `This is a link for Magic WAN's [Get started](https://developers.cloudflare.com/magic-wan/get-started/)`

**Also not supported:**

* Relative links: ``A link to [`DurableObjectNamespace::get`](./namespace)``
* Using the file extension in links: `This is a link for Magic WAN's [Get started](/magic-wan/get-started.mdx/)`

## Standard text

As much as possible, use text that follows one of these patterns:

* `For more information, refer to [<PAGE_TITLE>](LINK).`
* `To <DO_SOMETHING>, refer to [<SECTION_TITLE>](LINK).`

Do not use the following constructions:

* `Learn more about...`
* `To read more....`
* `For more information, refer the [Merge requests](LINK) page.`
* `For more information, refer the [Merge requests](LINK) documentation.`

## Descriptive link text

The more descriptive your link text, the easier it is for people to navigate your site and for Google to understand what you are linking to.

Practically, this means you should avoid link text like `here`, `this page`, or `read more`.

For example, instead of:

* `For more information, refer to [this page](LINK).`
* `For more information, go [here](LINK).`

Use:

* `For more information, refer to [set up Cloudflare](LINK).`

## Dashboard link text

When directing users to the Cloudflare dashboard, use the following convention:

```text
1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/login) and select your account and domain.
2. Go to **DNS** > **Records**.
```
