---
title: Acronyms · Cloudflare Style Guide
description: "Define new and unfamiliar terms. Acronyms and abbreviations can
  have an adverse effect on clarity, voice, and SEO. When writing or editing,
  some  terms might be unfamiliar to some or all of the audience. When you spot
  a such an unfamiliar term, take one of the following tactics:"
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/grammar/parts-of-speech/acronyms/
  md: https://developers.cloudflare.com/style-guide/grammar/parts-of-speech/acronyms/index.md
---

**Define new and unfamiliar terms.** Acronyms and abbreviations can have an adverse effect on clarity, voice, and SEO. When writing or editing, some terms might be unfamiliar to some or all of the audience. When you spot a such an unfamiliar term, take one of the following tactics:

* If the term already exists, link to a good existing explanation.

* If your document is introducing the term, define the term.

* **Do not use periods in acronyms.** Acronyms are usually pronounced as their own word (like “QUIC”); for that reason, we do not place periods between each letter. Although initialisms are slightly different from acronyms — like “VPN” or “TLS,” they cannot be pronounced as their own word — we format them in the same way as proper acronyms in order to maintain consistency throughout our written content.
