---
title: Error 1023 · Cloudflare Support docs
description: This error indicates that the host could not be found due to a
  configuration issue or propagation delay.
lastUpdated: 2025-05-14T13:30:35.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1023/
  md: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1023/index.md
---

## Error 1023: Could not find host

This error indicates that the host could not be found due to a configuration issue or propagation delay.

### Common causes

* If the owner just signed up for Cloudflare it can take a few minutes for the website's information to be distributed to our global network. Something is wrong with the site's configuration.
* Usually, this happens when accounts have been signed up with a partner organization (for example, hosting provider) and the provider's DNS fails.

Note

Error `1023` is returned via a HTTP `409` response code.

### Resolution

Contact [Cloudflare Support](https://developers.cloudflare.com/support/contacting-cloudflare-support/) with the following details:

* Your domain name.
* A screenshot of the `1023` error including the **RayID** mentioned in the error message.
* A [HAR file](https://developers.cloudflare.com/support/troubleshooting/general-troubleshooting/gathering-information-for-troubleshooting-sites/) captured while duplicating the error.
