---
title: Error 502 or 504 · Cloudflare Support docs
description: An HTTP 502 or 504 error indicates that Cloudflare is unable to
  establish contact with your origin web server.
lastUpdated: 2025-08-12T18:35:00.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-5xx-errors/error-502-504/
  md: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-5xx-errors/error-502-504/index.md
---

## Error 502 bad gateway or error 504 gateway timeout

An HTTP `502` or `504` error indicates that Cloudflare is unable to establish contact with your origin web server.

### Common causes

There are two possible causes:

* [`502/504` errors from your origin web server](#502504-from-your-origin-web-server) (most common).
* [`502/504` errors from Cloudflare](#502504-from-cloudflare).

You may also see `504` status codes in logs or analytics caused by [cache MISS responses from Early Hints](https://developers.cloudflare.com/cache/advanced-configuration/early-hints/#emit-early-hints).

### Resolution

To resolve `502/504` errors, it is essential to identify whether the issue originates from your origin web server or Cloudflare. In the following sections, you can find more details for troubleshooting and resolving errors from both sources.

#### 502/504 from your origin web server

Cloudflare returns a Cloudflare-branded HTTP `502` or `504` error when your origin web server responds with a standard HTTP `502 bad gateway` or `504 gateway timeout` error:

![Example of a Cloudflare-branded error 502.](https://developers.cloudflare.com/_astro/image1.bhOtPL9__Z6ha7r.webp)

Contact your hosting provider to troubleshoot these common causes at your origin web server:

* Ensure the origin server responds to requests for the hostname and domain within the visitor's URL that generated the `502` or `504` error.
* Investigate excessive server loads, crashes, or network failures.
* Identify applications or services that timed out or were blocked.

#### 502/504 from Cloudflare

A `502` or a `504` error originating from Cloudflare appears as follows, a blank page without the Cloudflare branding:

![Example of an unbranded error 502.](https://developers.cloudflare.com/_astro/image5.DQ6zBJUs_Z28DlYJ.webp)

If the error does not mention `cloudflare`, contact your hosting provider for assistance. Refer to [502/504 errors from your origin](#502504-from-your-origin-web-server) for more information.

This error can occur due to a compression issue at the origin, such as when the origin server serves gzip-encoded compressed content but fails to update the `content-length` header, or if the origin is serving broken gzip compressed content. To diagnose this, you can try disabling compression at your origin to confirm if it resolves the error.

Additionally, in some cases, a particular data center may experience a sudden increase in traffic. To ensure minimal impact for customers, our automated processes will redirect traffic to another data center. These adjustments typically happen seamlessly and take just a few seconds. However, during this process, some clients may experience temporary latency or HTTP `502` errors. You can find more information about our automated traffic management tools in this [blogpost](https://blog.cloudflare.com/meet-traffic-manager).

If you need further assistance from our Support team, provide the following details to [Cloudflare Support](https://developers.cloudflare.com/support/contacting-cloudflare-support/) to avoid delays in processing your inquiry:

* The timestamp along with the timezone in which the issue occurred.
* The URL that resulted in the HTTP `502` or `504` response (for example, `https://www.example.com/images/icons/image1.png`).
* The output from browsing to `<YOUR_DOMAIN>/cdn-cgi/trace`.

### Known Cloudflare issues leading to HTTP Error 502 or 504

* Using [Gateway](https://developers.cloudflare.com/cloudflare-one/policies/gateway/) can lead to an HTTP Error `502` if the origin only partially supports HTTP/2. Refer to [Gateway FAQ](https://developers.cloudflare.com/cloudflare-one/faq/troubleshooting/#i-see-error-504-when-browsing-to-a-website) for more details and resolution.

* You may see an influx of HTTP Error `504` with the `RequestSource` of `earlyHintsCache` in Cloudflare Logs when Early Hints is enabled, which is expected and benign. Refer to [the Early Hints article](https://developers.cloudflare.com/cache/advanced-configuration/early-hints/#emit-early-hints) for more details and resolution.
