---
title: Respond with another site · Cloudflare Workers docs
description: Respond to the Worker request with the response from another
  website (example.com in this example).
lastUpdated: 2025-08-20T18:47:44.000Z
chatbotDeprioritize: false
tags: Middleware,JavaScript,TypeScript,Python
source_url:
  html: https://developers.cloudflare.com/workers/examples/respond-with-another-site/
  md: https://developers.cloudflare.com/workers/examples/respond-with-another-site/index.md
---

If you want to get started quickly, click on the button below.

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/docs-examples/tree/main/workers/respond-with-another-site)

This creates a repository in your GitHub account and deploys the application to Cloudflare Workers.

* JavaScript

  ```js
  export default {
    async fetch(request) {
      async function MethodNotAllowed(request) {
        return new Response(`Method ${request.method} not allowed.`, {
          status: 405,
          headers: {
            Allow: "GET",
          },
        });
      }
      // Only GET requests work with this proxy.
      if (request.method !== "GET") return MethodNotAllowed(request);
      return fetch(`https://example.com`);
    },
  };
  ```

  [Run Worker in Playground](https://workers.cloudflare.com/playground#LYVwNgLglgDghgJwgegGYHsHALQBM4RwDcABAEbogB2+CAngLzbPYZb6HbW5QDGU2AAyCAzADYJAVgDso6QEYAXCxZtgHOFxp8Bw8VNkiFAWABQAYXRUIAU2vYAIlADOMdM6jQrikmrwFiEio4YBsGACIoGhsADwA6ACtncNJUKDA7ELDI6Pik8LNLazsIbAAVOhgbHzgYGDA+AigrZAS4ADc4Z14EWAgAamB0XHAbMzNYtyQSXBtUOHAIEgBvUxISLroqXl8bCF4ACwAKBBsARxAbZwgAShW19Y3nLZ3Ual4vKhIAWT2D4YAcugIABBMBgdAAdxsuBO50u1zuq0ej1OEBACC+VBskJIACUrm4qM4bEcAAa-CD-XAkAAky1OFyuEDioSpwwAvkFgRtwVCYXEyQAae4olHXAggZw+AAsgkkQoeYpIBxscFmCGlouVjzBEMhPnCAHEAKJlcKKnUkDmWsUcm5EJXWp3IZAkADyVDAdBIprKJEZCIgzhIkMwAGtQ54DiQqS4SDAEOgYnQ4k6oKgSHCmddWX9hiQAIQMBgkY1m8J3NEYr6U6lA0F86GwwPMh1O6uY3b7Y5kg4QCAwaWu2Iheo2OK8dDAMnt9Y20wcohmFTMNQaLQ8fhCUQSMQyOTyQpWWz2JyudyeZpUHx+DSkYKhCJs9UBFK+dKZJ-hMgQsgFCwTxKcpKmqDY6gaXgmhaJIrHGUxlnCYA4CiAB9IYRgycJFByWY8mSDkV1XdcAk3HQd30fdDAUZggA)

* TypeScript

  ```ts
  export default {
    async fetch(request): Promise<Response> {
      async function MethodNotAllowed(request) {
        return new Response(`Method ${request.method} not allowed.`, {
          status: 405,
          headers: {
            Allow: "GET",
          },
        });
      }
      // Only GET requests work with this proxy.
      if (request.method !== "GET") return MethodNotAllowed(request);
      return fetch(`https://example.com`);
    },
  } satisfies ExportedHandler;
  ```

* Python

  ```py
  from workers import WorkerEntrypoint, Response, fetch


  class Default(WorkerEntrypoint):
      def fetch(self, request):
          def method_not_allowed(request):
              msg = f'Method {request.method} not allowed.'
              headers = {"Allow": "GET"}
              return Response(msg, headers=headers, status=405)


          # Only GET requests work with this proxy.
          if request.method != "GET":
              return method_not_allowed(request)


          return fetch("https://example.com")
  ```
