---
title: Cache Keys · Cloudflare Cache (CDN) docs
description: A Cache Key is an identifier that Cloudflare uses for a file in our
  cache, and the Cache Key Template defines the identifier for a given HTTP
  request.
lastUpdated: 2025-10-06T13:41:54.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cache/how-to/cache-keys/
  md: https://developers.cloudflare.com/cache/how-to/cache-keys/index.md
---

A Cache Key is an identifier that Cloudflare uses for a file in our cache, and the Cache Key Template defines the identifier for a given HTTP request.

A default cache key includes:

1. Full URL:

   * scheme - could be HTTP or HTTPS.
   * host - for example, `www.cloudflare.com`
   * URI with query string - for example, `/logo.jpg`

2. Origin header sent by client (for CORS support).

3. `x-http-method-override`, `x-http-method`, and `x-method-override` headers.

4. `x-forwarded-host`, `x-host`, `x-forwarded-scheme` (unless http or https), `x-original-url`, `x-rewrite-url`, and `forwarded` headers.

## Create custom cache keys

Custom cache keys let you precisely set the cacheability setting for any resource. They provide the benefit of more control, though they may reduce your cache hit rate and result in cache sharding:

1. In the Cloudflare dashboard, go to the **Cache Rules** page.

   [Go to **Cache Rules**](https://dash.cloudflare.com/?to=/:account/:zone/caching/cache-rules)

2. Select **Create rule**.

3. Under **When incoming requests match**, define the [rule expression](https://developers.cloudflare.com/ruleset-engine/rules-language/expressions/edit-expressions/#expression-builder).

4. Under **Then**, in the **Cache eligibility** section, select **Eligible for cache**.

5. Add the **Cache Key** setting to the rule and select the appropriate **Query String** setting.

6. You can also select settings for **Headers**, **Cookie**, **Host**, and **User**.

7. To save and deploy your rule, select **Deploy**. If you are not ready to deploy your rule, select **Save as Draft**.

Note

When [URL normalization](https://developers.cloudflare.com/rules/normalization/) is enabled, we recommend also enabling [Normalize URLs to origin](https://developers.cloudflare.com/rules/normalization/manage/), especially if you are setting custom cache keys or using cache by device type, which also modifies the cache key. This helps ensure the URL in the cache key matches the URL sent to the origin, preventing cache poisoning and ensuring consistent behavior.

## Cache Key Template

There are a couple of common reasons to change the Cache Key Template. You might change the Cache Key Template to:

* Fragment the cache so one URL is stored in multiple files. For example, to store different files based on a specific query string in the URL.
* Consolidate the cache so different HTTP requests are stored in the same file. For example, to remove the Origin header added to Cloudflare Cache Keys by default.

### Impact of SSL settings on Cache behavior

Cloudflare's `$scheme` variable plays a key role in caching behavior, but its meaning varies depending on the cache key type:

* **Default Cache Key**: `$scheme` refers to the **origin scheme** — the protocol Cloudflare uses to connect to your origin server (HTTP or HTTPS). In this configuration, changes to your SSL settings (for example, switching from Flexible to Full) alter the origin scheme. Because the cache key includes the origin scheme, such changes trigger a cache bust, requiring Cloudflare to fetch content again from the origin.

* **Custom Cache Key**: `$scheme` refers to the **visitor's scheme** — the protocol used by the client making the request to Cloudflare. In this case, SSL setting changes do not impact the cache key unless the origin scheme is explicitly included in your custom configuration.

For example, with Flexible SSL, Cloudflare always connects to the origin over HTTP, regardless of whether the visitor uses HTTP or HTTPS. This results in the same cache key for both protocols under the default configuration.

Be aware that changes in the SSL setting can lead to cache invalidation when using the default cache key:

* Switching from **Off** to **Full**, **Full (strict)**, or **Strict** updates the origin scheme from HTTP to HTTPS, resulting in a cache bust.

* Moving from **Flexible** to **Full**, **Full (strict)**, or **Strict** similarly changes the origin scheme to HTTPS and causes a cache bust.

Understanding how `$scheme` interacts with your caching configuration is essential when modifying SSL modes to avoid unexpected cache behavior.

### Cache Level: Ignore Query String

A [Cache Level](https://developers.cloudflare.com/cache/how-to/set-caching-levels/) of Ignore Query String creates a Cache Key that includes all the elements in the default cache key, except for the query string in the URI that is no longer included. For instance, a request for `http://example.com/file.jpg?something=123` and a request for `http://example.com/file.jpg?something=789` will have the same cache key, in this case.

## Cache Key Settings

The following fields control the Cache Key Template.

### Query String

The query string controls which URL query string parameters go into the Cache Key. You can `include` specific query string parameters or `exclude` them using the respective fields. When you include a query string parameter, the `value` of the query string parameter is used in the Cache Key.

#### Example

If you include the query string foo in a URL like `https://www.example.com/?foo=bar`, then bar appears in the Cache Key. Exactly one of `include` or `exclude` is expected.

#### Usage notes

* To include all query string parameters (the default behavior), use include: `"\*"`
* To ignore query strings, use exclude: `"\*"`
* To include most query string parameters but exclude a few, use the exclude field which assumes the other query string parameters are included.

### Headers

Headers control which headers go into the Cache Key. Similar to Query String, you can include specific headers or exclude default headers.

When you include a header, the header value is included in the Cache Key. For example, if an HTTP request contains an HTTP header like `X-Auth-API-key: 12345`, and you include the `X-Auth-API-Key header` in your Cache Key Template, then `12345` appears in the Cache Key.

In the **Include headers and selected values** section, you can add header names and their values to the cache key. For custom headers, values are optional, but for the following restricted headers, you must include one to 10 specific values:

* `accept`
* `accept-charset`
* `accept-encoding`
* `accept-datetime`
* `accept-language`
* `referer`
* `user-agent`

To check for the presence of a header without including its actual value, use the **Check presence of** option.

Currently, you can only exclude the `Origin` header. The `Origin` header is always included unless explicitly excluded. Including the [Origin header](https://developer.mozilla.org/en-US/docs/Web/HTTP/Reference/Headers/Origin) in the Cache Key is important to enforce [CORS](https://developer.mozilla.org/en-US/docs/Glossary/CORS).

Additionally, you cannot include the following headers:

* Headers that re-implement cache or proxy features

  * `connection`
  * `content-length`
  * `cache-control`
  * `if-match`
  * `if-modified-since`
  * `if-none-match`
  * `if-unmodified-since`
  * `range`
  * `upgrade`

* Headers that are covered by other Cache Key features

  * `cookie`
  * `host`

* Headers that are specific to Cloudflare and prefixed with `cf-`, for example, `cf-ray`

* Headers that are already included in the custom Cache Key template, for example, `origin`

### Host

Host determines which host header to include in the Cache Key.

* If `Use original host` (`resolved: false` in the API), Cloudflare includes the `Host` header in the HTTP request sent to the origin.
* If `Resolved host` (`resolved: true` in the API), Cloudflare includes the `Host` header that was resolved to get the `origin IP` for the request. The `Host` header may be different from the header actually sent if it has been changed with an [Origin Rule](https://developers.cloudflare.com/rules/origin-rules/features/#dns-record).

### Cookie

Like `query_string` or `header`, `cookie` controls which cookies appear in the Cache Key. You can either include the cookie value or check for the presence of a particular cookie.

#### Usage notes

You cannot include cookies specific to Cloudflare. Cloudflare cookies are prefixed with `__cf`, for example, `__cflb`

### User features

User feature fields add features about the end-user (client) into the Cache Key.

* `device_type` classifies a request as `mobile`, `desktop`, or `tablet` based on the User Agent
* `geo` includes the client’s country, derived from the IP address
* `lang` includes the first language code contained in the `Accept-Language` header sent by the client

## Availability

Cache keys options availability varies according to your plan.

| | Free | Pro | Business | Enterprise |
| - | - | - | - | - |
| Cache deception armor | Yes | Yes | Yes | Yes |
| Cache by device type | Yes | Yes | Yes | Yes |
| Ignore query string | Yes | Yes | Yes | Yes |
| Sort query string | Yes | Yes | Yes | Yes |
| Query string | No | No | No | Yes |
| Headers | No | No | No | Yes |
| Cookie | No | No | No | Yes |
| Host | No | No | No | Yes |
| User features | No | No | No | Yes |

## Limitations

The [Prefetch](https://developers.cloudflare.com/speed/optimization/content/prefetch-urls/) feature is not compatible with the [Custom Cache Keys](https://developers.cloudflare.com/cache/how-to/cache-rules/examples/custom-cache-key/). With [Cache Rules](https://developers.cloudflare.com/cache/how-to/cache-rules/), the custom cache key is used to cache all assets. However, Prefetch always uses the default cache key. This results in a key mismatch.
