---
title: New REST API is in open beta! · Changelog
description: We've released a new REST API in open beta.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-02-27-br-rest-api-beta/
  md: https://developers.cloudflare.com/changelog/2025-02-27-br-rest-api-beta/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## New REST API is in open beta!

Feb 27, 2025

[Browser Rendering](https://developers.cloudflare.com/browser-rendering/)

We've released a new REST API for [Browser Rendering](https://developers.cloudflare.com/browser-rendering/) in open beta, making interacting with browsers easier than ever. This new API provides endpoints for common browser actions, with more to be added in the future.

With the **REST API** you can:

* **Capture screenshots** – Use `/screenshot` to take a screenshot of a webpage from provided URL or HTML.
* **Generate PDFs** – Use `/pdf` to convert web pages into PDFs.
* **Extract HTML content** – Use `/content` to retrieve the full HTML from a page. **Snapshot (HTML + Screenshot)** – Use `/snapshot` to capture both the page's HTML and a screenshot in one request
* **Scrape Web Elements** – Use `/scrape` to extract specific elements from a page.

For example, to capture a screenshot:

```bash
curl -X POST 'https://api.cloudflare.com/client/v4/accounts/<accountId>/browser-rendering/screenshot' \
  -H 'Authorization: Bearer <apiToken>' \
  -H 'Content-Type: application/json' \
  -d '{
    "html": "Hello World!",
    "screenshotOptions": {
      "type": "webp",
      "omitBackground": true
    }
  }' \
  --output "screenshot.webp"
```

Learn more in our [documentation](https://developers.cloudflare.com/browser-rendering/rest-api/).
