---
title: Remote bindings public beta - Connect to remote resources (D1, KV, R2,
  etc.) during local development · Changelog
description: You can now connect to R2 buckets, D1 databases, and other
  resources running on Cloudflare, while running your Worker's code locally, on
  your own machine.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-06-18-remote-bindings-beta/
  md: https://developers.cloudflare.com/changelog/2025-06-18-remote-bindings-beta/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Remote bindings public beta - Connect to remote resources (D1, KV, R2, etc.) during local development

Jun 18, 2025

[Workers](https://developers.cloudflare.com/workers/)

Today [we announced the public beta](https://github.com/cloudflare/workers-sdk/discussions/9660) of [remote bindings](https://developers.cloudflare.com/workers/development-testing/#remote-bindings) for local development. With remote bindings, you can now connect to deployed resources like [R2 buckets](https://developers.cloudflare.com/r2/) and [D1 databases](https://developers.cloudflare.com/d1/) while running Worker code on your local machine. This means you can test your local code changes against real data and services, without the overhead of deploying for each iteration.

#### Example configuration

To enable remote mode, add `"experimental_remote" : true` to each binding that you want to rely on a remote resource running on Cloudflare:

* wrangler.jsonc

  ```jsonc
  {
    "name": "my-worker",
    "compatibility_date": "2025-10-15",


    "r2_buckets": [
      {
        "bucket_name": "screenshots-bucket",
        "binding": "screenshots_bucket",
        "experimental_remote": true,
      },
    ],
  }
  ```

* wrangler.toml

  ```toml
  name = "my-worker"
  compatibility_date = "2025-10-15"


  [[r2_buckets]]
  bucket_name = "screenshots-bucket"
  binding = "screenshots_bucket"
  experimental_remote = true
  ```

When remote bindings are configured, your Worker **still executes locally**, but all binding calls are proxied to the deployed resource that runs on Cloudflare's network.

**You can try out remote bindings for local development today with:**

* [Wrangler v4.20.3](https://developers.cloudflare.com/workers/development-testing/#using-wrangler-with-remote-bindings): Use the `wrangler dev --x-remote-bindings` command.
* The [Cloudflare Vite Plugin](https://developers.cloudflare.com/workers/development-testing/#using-vite-with-remote-bindings): Refer to the documentation for how to enable in your Vite config.
* The [Cloudflare Vitest Plugin](https://developers.cloudflare.com/workers/development-testing/#using-vitest-with-remote-bindings): Refer to the documentation for how to enable in your Vitest config.

**Have feedback?** Join the discussion in our [beta announcement](https://github.com/cloudflare/workers-sdk/discussions/9660) to share feedback or report any issues.
