---
title: Expanded File Type Controls for Executables and Disk Images · Changelog
description: Block uploads and downloads of Apple Disk Images (DMG), Microsoft
  Application Installers (MSIX), and macOS Installer Packages (MPKG) to prevent
  the transfer of unauthorized software.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-10-01-new-file-type-support/
  md: https://developers.cloudflare.com/changelog/2025-10-01-new-file-type-support/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Expanded File Type Controls for Executables and Disk Images

Oct 01, 2025

[Data Loss Prevention](https://developers.cloudflare.com/cloudflare-one/policies/data-loss-prevention/)

You can now enhance your security posture by blocking additional application installer and disk image file types with Cloudflare Gateway. Preventing the download of unauthorized software packages is a critical step in securing endpoints from malware and unwanted applications.

We have expanded Gateway's file type controls to include:

* Apple Disk Image (dmg)
* Microsoft Software Installer (msix, appx)
* Apple Software Package (pkg)

You can find these new options within the [*Upload File Types* and *Download File Types* selectors](https://developers.cloudflare.com/cloudflare-one/policies/gateway/http-policies/#download-and-upload-file-types) when creating or editing an HTTP policy. The file types are categorized as follows:

* **System**: *Apple Disk Image (dmg)*
* **Executable**: *Microsoft Software Installer (msix)*, *Microsoft Software Installer (appx)*, *Apple Software Package (pkg)*

To ensure these file types are blocked effectively, please note the following behaviors:

* DMG: Due to their file structure, DMG files are blocked at the very end of the transfer. A user's download may appear to progress but will fail at the last moment, preventing the browser from saving the file.
* MSIX: To comprehensively block Microsoft Software Installers, you should also include the file type *Unscannable*. MSIX files larger than 100 MB are identified as Unscannable ZIP files during inspection.

To get started, go to your HTTP policies in Zero Trust. For a full list of file types, refer to [supported file types](https://developers.cloudflare.com/cloudflare-one/policies/gateway/http-policies/#supported-file-types).
