---
title: Backoff schedule · Cloudflare for Platforms docs
description: After you create a custom hostname, Cloudflare has to validate that hostname.
lastUpdated: 2025-04-11T13:02:33.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/domain-support/hostname-validation/backoff-schedule/
  md: https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/domain-support/hostname-validation/backoff-schedule/index.md
---

After you create a custom hostname, Cloudflare has to [validate that hostname](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/domain-support/hostname-validation/).

Attempts to validate a Custom Hostname are distributed over seven days (a total of 75 retries). At the end of this schedule, if the validation is unsuccessful, the custom hostname will be deleted. The function that determines the next check varies based on the number of attempts:

* For the first 10 attempts:

```txt
now() + min((floor(60 * pow(1.05, retry_attempt)) * INTERVAL '1 second'), INTERVAL '4 hours')
```

* For the remaining 65 attempts:

```txt
now() + min((floor(60 * pow(1.15, retry_attempt)) * INTERVAL '1 second'), INTERVAL '4 hours')
```

The first 10 checks complete within 20 minutes and most checks complete in the first four hours. The check back off is capped to a maximum of four hours to avoid exponential growth. The back off behavior causes larger gaps between check intervals towards the end of the back off schedule:

| Retry Attempt | In Seconds | In Minutes | In Hours |
| - | - | - | - |
| 0 | 60 | 1 | 0.016667 |
| 1 | 63 | 1.05 | 0.0175 |
| 2 | 66 | 1.1 | 0.018333 |
| 3 | 69 | 1.15 | 0.019167 |
| 4 | 72 | 1.2 | 0.02 |
| 5 | 76 | 1.266667 | 0.021111 |
| 6 | 80 | 1.333333 | 0.022222 |
| 7 | 84 | 1.4 | 0.023333 |
| 8 | 88 | 1.466667 | 0.024444 |
| 9 | 93 | 1.55 | 0.025833 |
| 10 | 242 | 4.033333 | 0.067222 |
| 11 | 279 | 4.65 | 0.0775 |
| 12 | 321 | 5.35 | 0.089167 |
| 13 | 369 | 6.15 | 0.1025 |
| 14 | 424 | 7.066667 | 0.117778 |
| 15 | 488 | 8.133333 | 0.135556 |
| 16 | 561 | 9.35 | 0.155833 |
| 17 | 645 | 10.75 | 0.179167 |
| 18 | 742 | 12.366667 | 0.206111 |
| 19 | 853 | 14.216667 | 0.236944 |
| 20 | 981 | 16.35 | 0.2725 |
| 21 | 1129 | 18.816667 | 0.313611 |
| 22 | 1298 | 21.633333 | 0.360556 |
| 23 | 1493 | 24.883333 | 0.414722 |
| 24 | 1717 | 28.616667 | 0.476944 |
| 25 | 1975 | 32.916667 | 0.548611 |
| 26 | 2271 | 37.85 | 0.630833 |
| 27 | 2612 | 43.533333 | 0.725556 |
| 28 | 3003 | 50.05 | 0.834167 |
| 29 | 3454 | 57.566667 | 0.959444 |
| 30 | 3972 | 66.2 | 1.103333 |
| 31 | 4568 | 76.133333 | 1.268889 |
| 32 | 5253 | 87.55 | 1.459167 |
| 33 | 6041 | 100.683333 | 1.678056 |
| 34 | 6948 | 115.8 | 1.93 |
| 35 | 7990 | 133.166667 | 2.219444 |
| 36 | 9189 | 153.15 | 2.5525 |
| 37 | 10567 | 176.116667 | 2.935278 |
| 38 | 12152 | 202.533333 | 3.375556 |
| 39 | 13975 | 232.916667 | 3.881944 |
| 40 | 14400 | 240 | 4 |
| 41 | 14400 | 240 | 4 |
| 42 | 14400 | 240 | 4 |
| 43 | 14400 | 240 | 4 |
| 44 | 14400 | 240 | 4 |
| 45 | 14400 | 240 | 4 |
| 46 | 14400 | 240 | 4 |
| 47 | 14400 | 240 | 4 |
| 48 | 14400 | 240 | 4 |
| 49 | 14400 | 240 | 4 |
| 50 | 14400 | 240 | 4 |
| 51 | 14400 | 240 | 4 |
| 52 | 14400 | 240 | 4 |
| 53 | 14400 | 240 | 4 |
| 54 | 14400 | 240 | 4 |
| 55 | 14400 | 240 | 4 |
| 56 | 14400 | 240 | 4 |
| 57 | 14400 | 240 | 4 |
| 58 | 14400 | 240 | 4 |
| 59 | 14400 | 240 | 4 |
| 60 | 14400 | 240 | 4 |
| 61 | 14400 | 240 | 4 |
| 62 | 14400 | 240 | 4 |
| 63 | 14400 | 240 | 4 |
| 64 | 14400 | 240 | 4 |
| 65 | 14400 | 240 | 4 |
| 66 | 14400 | 240 | 4 |
| 67 | 14400 | 240 | 4 |
| 68 | 14400 | 240 | 4 |
| 69 | 14400 | 240 | 4 |
| 70 | 14400 | 240 | 4 |
| 71 | 14400 | 240 | 4 |
| 72 | 14400 | 240 | 4 |
| 73 | 14400 | 240 | 4 |
| 74 | 14400 | 240 | 4 |
| 75 | 14400 | 240 | 4 |
