---
title: User-side certificates · Cloudflare Zero Trust docs
description: Advanced security features such as HTTPS traffic inspection, Data
  Loss Prevention, anti-virus scanning, Access for Infrastructure, and Browser
  Isolation require users to install and trust a root certificate on their
  device. You can either install the certificate provided by Cloudflare (default
  option), or generate your own custom certificate and upload it to Cloudflare.
lastUpdated: 2025-08-15T22:11:46.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/user-side-certificates/
  md: https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/user-side-certificates/index.md
---

Advanced security features such as [HTTPS traffic inspection](https://developers.cloudflare.com/cloudflare-one/policies/gateway/http-policies/tls-decryption/), [Data Loss Prevention](https://developers.cloudflare.com/cloudflare-one/policies/data-loss-prevention/), [anti-virus scanning](https://developers.cloudflare.com/cloudflare-one/policies/gateway/http-policies/antivirus-scanning/), [Access for Infrastructure](https://developers.cloudflare.com/cloudflare-one/applications/non-http/infrastructure-apps/), and [Browser Isolation](https://developers.cloudflare.com/cloudflare-one/policies/browser-isolation/) require users to install and trust a root certificate on their device. You can either install the certificate provided by Cloudflare (default option), or generate your own custom certificate and upload it to Cloudflare.

Zero Trust [generates a unique root CA](#generate-a-cloudflare-root-certificate) for each account and deploys it across the Cloudflare global network. Alternatively, Enterprise users can upload and deploy their own [custom certificate](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/user-side-certificates/custom-certificate/).

Default certificate expired on 2025-02-02

The default Cloudflare certificate expired on 2025-02-02 at 16:05 UTC.

Review how this change impacts certificate propagation to your end-user devices and how to address browser issues in [Troubleshooting](https://developers.cloudflare.com/cloudflare-one/faq/troubleshooting/#as-of-february-2-2025-my-end-user-devices-browser-is-returning-a-your-connection-is-not-private-warning).

## Certificate status

Zero Trust will indicate if a certificate is ready for use in inspection based on its deployment status:

| Deployment status | Description |
| - | - |
| Inactive | The certificate has been generated by or uploaded to Cloudflare but is not deployed across the global network. |
| Pending | The certificate is being activated or deactivated for use. |
| Available | The certificate is deployed across the Cloudflare global network and ready to be turned on. The WARP client will install the certificate on your users' devices. |
| Available and In-Use | The certificate is turned on. Gateway will use the certificate for inspection. |

## Generate a Cloudflare root certificate

To generate a new Cloudflare root certificate for your Zero Trust organization:

* Dashboard

  1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **Settings** > **Resources**.
  2. In **Certificates**, select **Manage**.
  3. Select **Generate certificate**.
  4. Choose a duration of time before the certificate expires. Cloudflare recommends expiration after five years. Alternatively, choose *Custom* and enter a custom amount in days.
  5. Select **Generate certificate**.

* API

  Send a `POST` request to the [Create Zero Trust certificate](https://developers.cloudflare.com/api/resources/zero_trust/subresources/gateway/subresources/certificates/methods/create/) endpoint.

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/certificates" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN"
  ```

  The API will respond with the ID and contents of the new certificate.

The certificate will appear in your list of certificates as **Inactive**. To download a generated certificate, select it, then choose **Download .pem** and/or **Download .crt**. To deploy your certificate and turn it on for inspection, you need to [activate the certificate](#activate-a-root-certificate).

Each Zero Trust account can generate a new root certificate a maximum of three times per day.

## Activate a root certificate

Note

Zero Trust accounts using the default Cloudflare certificate prior to 2024-10-17 will need to redeploy and activate the newly generated certificate. Zero Trust accounts created during or after 2024-10-17 will use an available certificate by default.

Once a certificate is generated in or uploaded to Zero Trust, you need to activate it. Activating a certificate deploys it across the Cloudflare network and sets its status to **Available**. You can have up to 10 available certificates at once.

To activate your root certificate:

* Dashboard

  1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **Settings** > **Resources**.
  2. In **Certificates**, select **Manage**.
  3. Select the certificate you want to activate.
  4. Select **Activate**.

* API

  Send a `POST` request to the [Activate a Zero Trust certificate](https://developers.cloudflare.com/api/resources/zero_trust/subresources/gateway/subresources/certificates/methods/activate/) endpoint.

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/certificates/$CERTIFICATE_ID/activate" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN"
  ```

The status of the certificate will change to **Pending** while it deploys. Once the status of your certificate is **Available**, you can install it on your user's devices either [with WARP](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/user-side-certificates/automated-deployment/) or [manually](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/user-side-certificates/manual-deployment/).

Once you deploy and install your certificate, you can turn it on for use in inspection:

* Dashboard

  1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **Settings** > **Resources**.
  2. In **Certificates**, select **Manage**.
  3. Select the certificate you want to turn on.
  4. In **Basic information**, select **Confirm and turn on certificate**.

* API

  Send a `PUT` request to the [Update Zero Trust account configuration](https://developers.cloudflare.com/api/resources/zero_trust/subresources/gateway/subresources/configurations/methods/update/) endpoint. For example:

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/configuration" \
    --request PUT \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "settings": {
          "certificate": {
              "id": "{certificate_id}",
              "in_use": true
          }
      }
    }'
  ```

You can set multiple certificates to **Available**, but you can only turn on one certificate for use in inspection at a time. Setting a certificate as **In-Use** will set any other in-use certificates as **Available** only and prevent them from being used for inspection until turned on again.
