---
title: Require WARP · Cloudflare Zero Trust docs
description: Cloudflare Zero Trust enables you to restrict access to your
  applications to devices running the Cloudflare WARP client. This allows you to
  flexibly ensure that a user's traffic is secure and encrypted before allowing
  access to a resource protected behind Cloudflare Zero Trust.
lastUpdated: 2025-08-22T14:24:45.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/require-warp/
  md: https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/require-warp/index.md
---

Note

This device posture attribute will check for all versions of WARP, including the consumer version.

Cloudflare Zero Trust enables you to restrict access to your applications to devices running the Cloudflare WARP client. This allows you to flexibly ensure that a user's traffic is secure and encrypted before allowing access to a resource protected behind Cloudflare Zero Trust.

## Prerequisites

* Cloudflare WARP client is [deployed](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/) on the device. For a list of supported modes and operating systems, refer to [WARP Client Checks](https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/).

## 1. Enable the WARP check

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Settings** > **Network**.
2. Ensure that **Proxy** is enabled.
3. Go to **Settings** > **WARP Client**.
4. In **WARP client checks**, select **Add new**.
5. Select **WARP**, then select **Save**.

## 2. Add the check to an Access policy

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Access** > **Applications**.

2. Locate the application for which you want to require WARP. Select **Configure**.

3. In the **Policies** tab, create a new Access policy or edit an existing policy.

4. In the policy builder, add an Include or Require rule which uses the *WARP* selector. Save the policy.

5. Save the Access application.

Before granting access to the application, the policy will check that the device is running the WARP client.
