---
title: Signed AuthN requests (SAML) · Cloudflare Zero Trust docs
description: In a SAML request flow, Cloudflare Access functions as the service
  provider (SP) to the identity provider (IdP). Cloudflare Access sends a SAML
  request to your IdP. The signing certificate that you upload from your SAML
  provider verifies the response.
lastUpdated: 2024-11-27T20:41:19.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/identity/idp-integration/signed_authn/
  md: https://developers.cloudflare.com/cloudflare-one/identity/idp-integration/signed_authn/index.md
---

In a SAML request flow, Cloudflare Access functions as the service provider (SP) to the identity provider (IdP). Cloudflare Access sends a SAML request to your IdP. The signing certificate that you upload from your SAML provider verifies the response.

In some cases, administrators need to verify that the request from the SP is authentic. By validating both the requests from the SP and the responses from the IdP, teams can ensure that operations in the SAML relationship are signed in both directions.

Cloudflare Access supports this requirement in the form of Signed AuthN requests. When enabled, Access sends a signature embedded in an HTTP POST request that contains the AuthN details.

## Set up Signed AuthN requests

To set up Signed AuthN requests:

1. In Zero Trust, go to **Settings** > **Authentication**.

2. Under **Login methods**, select **Add new**.

3. Choose **SAML** on the next page.

4. Complete the fields in the dialog.

5. Go to this URL to find the certificate:

   ```txt
   https://<your-team-name>.cloudflareaccess.com/cdn-cgi/access/public-cert
   ```

   Ensure that your IdP validation uses the most recent certificate. Cloudflare Access routinely rotates the public key as a security measure.

   Cloudflare Access uses a certificate that includes the following 2 distinguished name fields:

   * **Issuer Distinguished Name** - `CN=cloudflareaccess.com, C=US, ST=Texas, L=Austin, O=Cloudflare`
   * **Subject Distinguished Name** - `CN=*.cloudflareaccess.com, C=US, ST=Texas, L=Austin, O=Cloudflare`

   Most IdP configurations require 3 components to enforce AuthN signature verification:

   * **Certificate issuer [distinguished name (DN)](https://knowledge.digicert.com/generalinformation/INFO1745.html)**
   * **Certificate subject distinguished name**
   * **Public certificate**

6. In your IdP account, replace your authorization domain with the team domain generated by Cloudflare Access.

   This is an example format:

   ```txt
   https://<your-team-name>.cloudflareaccess.com/cdn-cgi/access/public-cert
   ```
