---
title: Isolate self-hosted application · Cloudflare Zero Trust docs
description: With Access policies, you can require users to open self-hosted
  applications in a secure remote browser. Because the remote browser is
  directly integrated into our Secure Web Gateway platform, HTTP policies can be
  applied to isolated applications without needing to install the WARP client.
  This allows you to distribute internal applications to unmanaged users while
  retaining control over sensitive data.
lastUpdated: 2025-08-20T21:45:15.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/policies/access/isolate-application/
  md: https://developers.cloudflare.com/cloudflare-one/policies/access/isolate-application/index.md
---

Note

Requires [Cloudflare Browser Isolation](https://developers.cloudflare.com/cloudflare-one/policies/browser-isolation/).

With Access policies, you can require users to open self-hosted applications in a secure [remote browser](https://developers.cloudflare.com/cloudflare-one/policies/browser-isolation/). Because the remote browser is directly integrated into our Secure Web Gateway platform, [HTTP policies](https://developers.cloudflare.com/cloudflare-one/policies/gateway/http-policies/) can be applied to isolated applications without needing to install the WARP client. This allows you to distribute internal applications to unmanaged users while retaining control over sensitive data.

## Prerequisites

Your browser must [allow third-party cookies](https://developers.cloudflare.com/cloudflare-one/identity/authorization-cookie/#allow-third-party-cookies-in-the-browser) on the application domain.

## Enable Browser Isolation

1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **Settings** > **Browser Isolation**.
2. Enable **Clientless Web Isolation**.

1) Go to **Access** > **Applications**.
2) Choose a [self-hosted application](https://developers.cloudflare.com/cloudflare-one/applications/configure-apps/self-hosted-public-app/) and select **Configure**.
3) Go to **Policies**.
4) Choose an [Allow policy](https://developers.cloudflare.com/cloudflare-one/policies/access/) and select **Configure**.
5) Under **Additional settings**, turn on **Isolate application**.
6) Save the policy.

Browser Isolation is now enabled for users who match this policy. After the user logs into Access, the application will launch in a remote browser. To confirm that the application is isolated, refer to [Check if a web page is isolated](https://developers.cloudflare.com/cloudflare-one/policies/browser-isolation/setup/#3-check-if-a-web-page-is-isolated).

You can optionally add another Allow policy for users on managed devices who do not require isolation.

## Policies for isolated applications

Traffic to the isolated Access application is filtered by your Gateway [HTTP policies](https://developers.cloudflare.com/cloudflare-one/policies/gateway/http-policies/). Useful policies include:

* [Identity-based policies](https://developers.cloudflare.com/cloudflare-one/policies/gateway/identity-selectors/) to allow or block requests based on user identity.
* [Data Loss Prevention policies](https://developers.cloudflare.com/cloudflare-one/policies/data-loss-prevention/) to log or block transmission of sensitive data.
* [Isolation policies](https://developers.cloudflare.com/cloudflare-one/policies/browser-isolation/isolation-policies/) to disable browser actions such as copy/paste, printing, or file downloads.

For example, if your application is hosted on `internal.site.com`, the following policy blocks users from uploading and downloading credit card numbers within the remote browser:

| Selector | Operator | Value | Logic | Action |
| - | - | - | - | - |
| Domain | in | `internal.site.com` | And | Block |
| DLP Profile | in | `Financial Information` | | |

## Product compatibility

For a list of products that are incompatible with the **Isolate application** feature, refer to [Product Compatibility](https://developers.cloudflare.com/cloudflare-one/applications/configure-apps/self-hosted-public-app/#product-compatibility) .
