---
title: TLS decryption · Cloudflare Zero Trust docs
description: Cloudflare Gateway can perform SSL/TLS decryption in order to
  inspect HTTPS traffic for malware and other security risks.
lastUpdated: 2025-07-24T19:58:35.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/policies/gateway/http-policies/tls-decryption/
  md: https://developers.cloudflare.com/cloudflare-one/policies/gateway/http-policies/tls-decryption/index.md
---

Cloudflare Gateway can perform [SSL/TLS decryption](https://www.cloudflare.com/learning/security/what-is-https-inspection/) in order to inspect HTTPS traffic for malware and other security risks.

When you turn on TLS decryption, Gateway will decrypt all traffic sent over HTTPS, apply your HTTP policies, and then re-encrypt the request with a [user-side certificate](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/user-side-certificates/).

Cloudflare prevents traffic interference by decrypting, inspecting, and re-encrypting HTTPS requests in its data centers in memory only. Gateway only stores eligible cache content at rest. All cache disks are encrypted at rest. You can configure where TLS decryption takes place with [Regional Services](https://developers.cloudflare.com/data-localization/regional-services/) in the [Cloudflare Data Localization Suite (DLS)](https://developers.cloudflare.com/data-localization/). To further control what data centers traffic egresses from, you can use [dedicated egress IPs](https://developers.cloudflare.com/cloudflare-one/policies/gateway/egress-policies/dedicated-egress-ips/).

Cloudflare supports connections from users to Gateway over TLS 1.1, 1.2, and 1.3.

## Turn on TLS decryption

Prerequisite

Before you turn on TLS decryption, ensure you have installed either a [Cloudflare-generated certificate](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/user-side-certificates/) or [custom certificate](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/user-side-certificates/custom-certificate/) on your users' devices.

To turn on TLS decryption:

* Dashboard

  1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **Settings** > **Network**.
  2. In **Firewall**, turn on **TLS decryption**.

* Terraform (v5)

  1. Add the following permission to your [`cloudflare_api_token`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/api_token):

     * `Zero Trust Write`

  2. Configure the `tls_decrypt` argument in [`cloudflare_zero_trust_gateway_settings`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/zero_trust_gateway_settings):

     ```tf
     resource "cloudflare_zero_trust_gateway_settings" "team_name" {
       account_id = var.cloudflare_account_id
       settings = {
         tls_decrypt = {
           enabled = true
         }
       }
     }
     ```

## Inspection limitations

Gateway does not support TLS decryption for applications which use:

* [Certificate pinning](#incompatible-certificates)
* [Self-signed certificates](#incompatible-certificates)
* [Mutual TLS (mTLS) authentication](#incompatible-certificates)
* [ESNI and ECH handshake encryption](#esni-and-ech)
* [Automatic HTTPS upgrades](#google-chrome-automatic-https-upgrades)

### Inspect on all ports Beta

By default, Gateway will only inspect HTTP traffic through port `80`. Additionally, if you [turn on TLS decryption](https://developers.cloudflare.com/cloudflare-one/policies/gateway/http-policies/tls-decryption/#turn-on-tls-decryption), Gateway will inspect HTTPS traffic through port `443`.

To detect and inspect HTTP and HTTPS traffic on ports in addition to `80` and `443`, you can turn on [protocol detection](https://developers.cloudflare.com/cloudflare-one/policies/gateway/network-policies/protocol-detection/) and configure Gateway to [inspect traffic on all ports](https://developers.cloudflare.com/cloudflare-one/policies/gateway/network-policies/protocol-detection/#inspect-on-all-ports).

Inspecting traffic on all ports works best if you allow all traffic by default. If your organization uses a Network policy to block all traffic by default, Gateway will allow all non-HTTPS TLS traffic, and you will not be able to filter this traffic. To use HTTP policies to filter all TLS traffic on all ports when using a default Block Network policy, [create a Network policy to explicitly allow HTTP and TLS traffic](https://developers.cloudflare.com/cloudflare-one/policies/gateway/network-policies/common-policies/#filter-http-traffic-when-inspecting-on-all-ports).

### Incompatible certificates

Applications that use certificate pinning and mTLS authentication do not trust Cloudflare certificates. For example, most mobile applications use [certificate pinning](https://developers.cloudflare.com/ssl/reference/certificate-pinning/). Cloudflare does not trust applications that use self-signed certificates instead of certificates signed by a public CA.

If you try to perform TLS decryption on an application with an incompatible certificate configuration, the application may return an SSL or trust error and/or fail to load. To resolve this issue, you can:

* Add a [Cloudflare certificate](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/user-side-certificates/manual-deployment/#add-the-certificate-to-applications) to supported applications.
* Create a [Do Not Inspect policy](https://developers.cloudflare.com/cloudflare-one/policies/gateway/http-policies/#do-not-inspect) to exempt applications from inspection. The [Application selector](https://developers.cloudflare.com/cloudflare-one/policies/gateway/http-policies/#application) provides a list of trusted applications that are known to use embedded certificates. Note that if you create a Do Not Inspect policy for an application or website, you will lose the ability to log or block HTTP requests, apply DLP policies, and perform AV scanning.
* Configure a [Split Tunnel](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/split-tunnels/) in Include mode to ensure Gateway will only inspect traffic destined for your IPs or domains. This is useful for organizations that deploy Zero Trust on users' personal devices or otherwise expect personal applications to be used.

Alternatively, to allow HTTP filtering while accessing a site with an insecure certificate, set your [Untrusted certificate action](https://developers.cloudflare.com/cloudflare-one/policies/gateway/http-policies/#untrusted-certificates) to *Pass through*.

### Google Chrome automatic HTTPS upgrades

Google Chrome can automatically upgrade HTTP requests to HTTPS requests, even when you select a link that explicitly declares `http://`. When you use Gateway to proxy and filter your traffic, this upgrade can interrupt the connection between your Zero Trust users and Gateway.

You can turn off automatic HTTPS upgrades via a Gateway pass through policy, a Chrome browser flag, or a Chrome Enterprise policy.

* Pass through policy

  To disable automatic HTTPS upgrades for a URL across your Zero Trust organization, create a Gateway pass through policy.

  1. Deploy a [custom root certificate](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/user-side-certificates/custom-certificate/).

  2. Create an [HTTP policy](https://developers.cloudflare.com/cloudflare-one/policies/gateway/http-policies/) to match the domain of the URL being automatically upgraded. For example:

     | Selector | Operator | Value | Action |
     | - | - | - | - |
     | URL | in | `example.com` | Allow |

  3. In **Untrusted certificate action**, choose *Pass through*.

  4. Select **Create policy**.

  The pass through policy will bypass insecure connection upgrades for any device connected to your Zero Trust organization. For more information, refer to [Untrusted certificates](https://developers.cloudflare.com/cloudflare-one/policies/gateway/http-policies/#untrusted-certificates).

* Chrome browser flag

  To disable automatic HTTPS upgrades on a per-browser basis, go to [Chrome flags](chrome://flags/#https-upgrades) and turn off **HTTPS Upgrades**.

* Chrome enterprise policy

  Chrome Enterprise users can turn off automatic HTTPS upgrades for all URLs with a [`HttpsUpgradesEnabled` management policy](https://chromeenterprise.google/policies/#HttpsUpgradesEnabled).

### Mutual TLS (mTLS)

When decrypting TLS to inspect traffic, connections that use mutual TLS (mTLS) will fail because Gateway cannot return the necessary client certificate. To prevent connection failures, create a [Do Not Inspect policy](https://developers.cloudflare.com/cloudflare-one/policies/gateway/http-policies/#do-not-inspect) for this traffic.

### ESNI and ECH

Websites that adhere to [ESNI or Encrypted Client Hello (ECH) standards](https://blog.cloudflare.com/encrypted-client-hello/) encrypt the Server Name Indicator (SNI) during the TLS handshake and are therefore incompatible with HTTP inspection. This is because Gateway relies on the SNI to match an HTTP request to a policy. If the ECH fails, browsers will retry the TLS handshake using the unencrypted SNI from the initial request. To avoid this behavior, you can disable ECH in your users' browsers.

You can still apply all [network policy filters](https://developers.cloudflare.com/cloudflare-one/policies/gateway/network-policies/#selectors) except for SNI and SNI Domain. To restrict ESNI and ECH traffic, an option is to filter out all port `80` and `443` traffic that does not include an SNI header.

## Post-quantum support

Gateway supports post-quantum cryptography using a hybrid key exchange with X25519 and MLKEM768 over TLS 1.3. Once the key exchange is complete, Gateway uses AES-128-GCM to encrypt traffic.

Refer to [Post-quantum cryptography](https://developers.cloudflare.com/ssl/post-quantum-cryptography/) to learn more.

## FIPS compliance

By default, TLS decryption can use both TLS version 1.2 and 1.3. However, some environments such as FedRAMP may require cipher suites and TLS versions compliant with FIPS 140-2. FIPS compliance currently requires TLS version 1.2.

### Enable FIPS compliance

* Dashboard

  1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **Settings** > **Network**.
  2. In **Firewall**, turn on **TLS decryption**.

* Terraform (v5)

  1. Add the following permission to your [`cloudflare_api_token`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/api_token):

     * `Zero Trust Write`

  2. Configure the `tls_decrypt` argument in [`cloudflare_zero_trust_gateway_settings`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/zero_trust_gateway_settings):

     ```tf
     resource "cloudflare_zero_trust_gateway_settings" "team_name" {
       account_id = var.cloudflare_account_id
       settings = {
         tls_decrypt = {
           enabled = true
         }
       }
     }
     ```

1. Select **Enable only cipher suites and TLS versions compliant with FIPS 140-2**.

### Limitations

When FIPS compliance is enabled, Gateway will only choose [FIPS-compliant cipher suites](#cipher-suites) when connecting to the origin. If the origin does not support FIPS-compliant ciphers, the request will fail.

FIPS-compliant traffic defaults to [HTTP/3](https://developers.cloudflare.com/cloudflare-one/policies/gateway/http-policies/http3/). To enforce HTTP policies for UDP traffic, you must turn on the [Gateway proxy for UDP](https://developers.cloudflare.com/cloudflare-one/policies/gateway/http-policies/http3/#enable-http3-inspection).

## FedRAMP compliance

When you use [Cloudflare Regional Services](https://developers.cloudflare.com/data-localization/regional-services/) in the United States and the WARP client to on-ramp TLS traffic to Gateway, traffic will egress from a Cloudflare data center within Cloudflare's FedRAMP boundary. If a user's closest data center is non-FedRAMP compliant, their traffic will still egress from a FedRAMP compliant data center, maintaining FedRAMP compliance for the traffic.

```mermaid
flowchart LR
 %% Accessibility
 accTitle: How Gateway routes FedRAMP compliant traffic with Regional Services
 accDescr: Flowchart describing how WARP with Gateway routes traffic to egress from a FedRAMP compliant data center when used with Regional Services in the United States.

 %% Flowchart
 subgraph s1["Non-FedRAMP data center"]
        n2["WARP TLS encryption terminated"]
  end
 subgraph s2["FedRAMP data center"]
        n3["Gateway TLS encryption (FIPS) terminated"]
  end
 subgraph s3["Private internal network"]
        n5["FedRAMP compliant cloudflared"]
        n6(["Private server"])
  end
    n1(["User near non-FedRAMP compliant data center"]) -- Gateway TLS connection wrapped with WARP TLS (MASQUE) --> n2
    n2 -- Gateway TLS connection --> n3
    n3 <-- FIPS tunnel --> n5
    n5 --> n6

    n5@{ shape: rect}
```

## Cipher suites

A cipher suite is a set of encryption algorithms for establishing a secure communications connection. There are several cipher suites in wide use, and a client and server agree on the cipher suite to use when establishing the TLS connection. Support of multiple cipher suites allows compatibility across various clients.

The following table lists the default cipher suites Gateway uses for TLS decryption.

| Name (OpenSSL) | Name (IANA) | FIPS-compliant |
| - | - | - |
| ECDHE-ECDSA-AES128-GCM-SHA256 | TLS\_ECDHE\_ECDSA\_WITH\_AES\_128\_GCM\_SHA256 | ✅ |
| ECDHE-ECDSA-AES256-GCM-SHA384 | TLS\_ECDHE\_ECDSA\_WITH\_AES\_256\_GCM\_SHA384 | ✅ |
| ECDHE-RSA-AES128-GCM-SHA256 | TLS\_ECDHE\_RSA\_WITH\_AES\_128\_GCM\_SHA256 | ✅ |
| ECDHE-RSA-AES256-GCM-SHA384 | TLS\_ECDHE\_RSA\_WITH\_AES\_256\_GCM\_SHA384 | ✅ |
| ECDHE-RSA-AES128-SHA | TLS\_ECDHE\_RSA\_WITH\_AES\_128\_CBC\_SHA256 | ❌ |
| ECDHE-RSA-AES256-SHA384 | TLS\_ECDHE\_RSA\_WITH\_AES\_256\_CBC\_SHA384 | ✅ |
| AES128-GCM-SHA256 | TLS\_RSA\_WITH\_AES\_128\_GCM\_SHA256 | ✅ |
| AES256-GCM-SHA384 | TLS\_RSA\_WITH\_AES\_256\_GCM\_SHA384 | ✅ |
| AES128-SHA | TLS\_RSA\_WITH\_AES\_128\_CBC\_SHA | ❌ |
| AES256-SHA | TLS\_RSA\_WITH\_AES\_256\_CBC\_SHA | ❌ |

For more information on cipher suites, refer to [Cipher suites](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/cipher-suites/).
