---
title: Roles and permissions · Cloudflare Zero Trust docs
description: When creating a Cloudflare Zero Trust account, you will be given
  the Super Administrator role. As a Super Administrator, you can invite members
  to join your Zero Trust account and assign them different roles. There is no
  limit to the number of members which can be added to a given account. Any
  members with the proper permissions will be able to make configuration changes
  while actively logged into Zero Trust (unless read-only mode is enabled).
lastUpdated: 2025-08-28T17:52:51.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/roles-permissions/
  md: https://developers.cloudflare.com/cloudflare-one/roles-permissions/index.md
---

When creating a Cloudflare Zero Trust account, you will be given the Super Administrator role. As a Super Administrator, you can invite members to join your Zero Trust account and assign them different roles. There is no limit to the number of members which can be added to a given account. Any members with the proper permissions will be able to make configuration changes while actively logged into Zero Trust (unless [read-only mode](https://developers.cloudflare.com/cloudflare-one/api-terraform/#set-dashboard-to-read-only) is enabled).

To check the list of members in your account, or to manage roles and permissions, refer to our [Account setup](https://developers.cloudflare.com/fundamentals/manage-members/) documentation.

## Zero Trust roles

Only Super Administrators will be able to assign or remove the following roles from users in their account. Scroll to the right to see a full list of permissions for each role.

| | Access Read | Access Edit | Gateway Read | Gateway Edit | Gateway Report | DNS Location Read | DNS Location Edit | Billing Read | Billing Edit | DEX Read | DEX Edit |
| - | - | - | - | - | - | - | - | - | - | - | - |
| Super Administrator | ✅ | ✅ | ✅ | ✅ | ✅ | ✅ | ✅ | ✅ | ✅ | ✅ | ✅ |
| Cloudflare Zero Trust[1](#user-content-fn-1) | ✅ | ✅ | ✅ | ✅ | ✅ | ✅ | ✅ | ✅ | ❌ | ✅ | ✅ |
| Cloudflare Access | ✅ | ✅ | ✅ | ❌ | ✅ | ❌ | ❌ | ✅ | ❌ | ❌ | ❌ |
| Cloudflare Gateway | ✅ | ❌ | ✅ | ✅ | ✅ | ✅ | ✅ | ✅ | ❌ | ❌ | ❌ |
| Cloudflare Zero Trust Read Only | ✅ | ❌ | ✅ | ❌ | ✅ | ✅ | ❌ | ✅ | ❌ | ✅ | ❌ |
| Cloudflare Zero Trust Reporting | ❌ | ❌ | ❌ | ❌ | ✅ | ❌ | ❌ | ✅ | ❌ | ✅ | ❌ |
| Cloudflare Zero Trust DNS Locations Write[2](#user-content-fn-2) | ❌ | ❌ | ❌ | ❌ | ❌ | ✅ | ✅ | ❌ | ❌ | ❌ | ❌ |
| Cloudflare DEX | ❌ | ❌ | ❌ | ❌ | ❌ | ❌ | ❌ | ❌ | ❌ | ✅ | ✅ |

### Cloudflare Zero Trust PII

By default, only Super Administrators can view end users' PII in the Gateway activity logs, such as Device IDs, Source IPs, or user emails. No other roles will have the ability to read PII unless Super Administrators explicitly assign the **Cloudflare Zero Trust PII** role to them.

The Cloudflare Zero Trust PII role should be considered an add-on role, to be combined with any role from the table above. For example, Super Administrators may decide to assign the Cloudflare Gateway role to a user, and add the Cloudflare Zero Trust PII role to allow that user to access PII in the Gateway logs.

Note

The Cloudflare Zero Trust PII role does not apply to Access audit logs. PII is always visible in Access logs.

## Email Security roles

For more information on Email Security roles, refer to [Account-scoped roles](https://developers.cloudflare.com/fundamentals/manage-members/roles/#account-scoped-roles).

* **Cloudflare Zero Trust**: Can edit Cloudflare [Zero Trust](https://developers.cloudflare.com/cloudflare-one/). Grants administrator access to all Zero Trust products including Access, Gateway, WARP, Tunnel, Browser Isolation, CASB, DLP, DEX, and Email Security.
* **Cloudflare Zero Trust PII**: Can read PII in Zero Trust. This includes Email Security.
* **Email Security Analyst** and **Email Security Configuration Admin**: Has full access to all admin features in Email Security.
* **Email Security Integration Admin**: Can read and set up integrations only.
* **Email Security Configuration Admin**: Has administrator access. Cannot take actions on emails, or read emails.
* **Email Security Analyst**: Has analyst access. Can take action on emails and read emails.
* **Email Security Reporting**: Can read metrics.
* **Email Security Read Only**: Can read all information, but cannot take action on anything.
* **Email Security Policy Admin**: Can read all settings, but only write [allow policies](https://developers.cloudflare.com/cloudflare-one/email-security/detection-settings/allow-policies/), [trusted domains](https://developers.cloudflare.com/cloudflare-one/email-security/detection-settings/trusted-domains/), and [blocked senders](https://developers.cloudflare.com/cloudflare-one/email-security/detection-settings/blocked-senders/).

## Footnotes

1. The **Cloudflare Zero Trust** role grants administrator access to all Zero Trust products including Access, Gateway, WARP, Tunnel, Browser Isolation, CASB, DLP, DEX, and Email Security. [↩](#user-content-fnref-1)

2. Users with the **Cloudflare Zero Trust DNS Locations Write** role can view all DNS locations for an organization but can only create and edit [secure DNS locations](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/agentless/dns/locations/#secure-dns-locations). [↩](#user-content-fnref-2)
