---
title: Internal zones · Cloudflare DNS docs
description: Explore internal DNS zones in Cloudflare. These zones organize DNS
  records for resources accessible only within your private network, queried via
  Cloudflare Gateway.
lastUpdated: 2025-06-06T12:18:43.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/dns/internal-dns/internal-zones/
  md: https://developers.cloudflare.com/dns/internal-dns/internal-zones/index.md
---

Internal DNS zones are groupings of internal DNS records. While [public DNS records](https://developers.cloudflare.com/dns/manage-dns-records/) contain information about resources that you want to make available to the public Internet, [internal DNS records](https://developers.cloudflare.com/dns/internal-dns/internal-zones/internal-dns-records/) allow you to manage resources that should only be available within your private network.

Refer to [Manage internal zones](https://developers.cloudflare.com/dns/internal-dns/internal-zones/setup/) for a full list of configuration conditions and step-by-step instructions.

Internal DNS zones do not get assigned Cloudflare nameservers and can only be queried via [Cloudflare Gateway](https://developers.cloudflare.com/cloudflare-one/policies/gateway/resolver-policies/) when linked to a [DNS view](https://developers.cloudflare.com/dns/internal-dns/dns-views/). The Gateway configuration must exist within the same Cloudflare account where the internal zone exists.

## Resources

* [Manage internal zones](https://developers.cloudflare.com/dns/internal-dns/internal-zones/setup/)
* [Manage internal DNS records](https://developers.cloudflare.com/dns/internal-dns/internal-zones/internal-dns-records/)
* [Reference zones](https://developers.cloudflare.com/dns/internal-dns/internal-zones/reference-zones/)
