---
title: Create a new Access Control List · Cloudflare DNS docs
description: You need to create an Access Control List (ACL) if Cloudflare is
  your secondary DNS provider. The ACL will specify additional NOTIFY IPs that
  Cloudflare should listen to.
lastUpdated: 2025-09-04T10:36:01.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/dns/zone-setups/zone-transfers/access-control-lists/create-new-list/
  md: https://developers.cloudflare.com/dns/zone-setups/zone-transfers/access-control-lists/create-new-list/index.md
---

You need to create an Access Control List (ACL) if Cloudflare is your [secondary DNS provider](https://developers.cloudflare.com/dns/zone-setups/zone-transfers/cloudflare-as-secondary/). The ACL will specify additional NOTIFY IPs that Cloudflare should listen to.

An ACL is configured at the account level, which means that it will apply to every primary and secondary zone in your account.

* Dashboard

  To create a new ACL using the dashboard:

  1. In the Cloudflare dashboard, go to the account **Settings** page.

     [Go to **Settings**](https://dash.cloudflare.com/?to=/:account/configurations)

  2. Go to **DNS Settings**.

  3. Under **DNS Zone Transfers**, for **ACL**, select **Create**.

  4. Enter the following information:

     * **ACL name**: Provide a descriptive name.
     * **IP range**: Enter a range of IPv4 or IPv6 addresses (limited to a maximum of /24 for IPv4 and /64 for IPv6).

  5. Select **Create**.

* API

  To create a new ACL using the API, send a [POST](https://developers.cloudflare.com/api/resources/dns/subresources/zone_transfers/subresources/acls/methods/create/) request.
