---
title: Firewall rules JSON object · Cloudflare Firewall Rules (deprecated) docs
description: "A JSON response for the Firewall Rules API has this structure:"
lastUpdated: 2025-05-06T08:26:18.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/firewall/api/cf-firewall-rules/json-object/
  md: https://developers.cloudflare.com/firewall/api/cf-firewall-rules/json-object/index.md
---

## Firewall rule example JSON response

A JSON response for the [Firewall Rules API](https://developers.cloudflare.com/api/resources/firewall/subresources/rules/methods/list/) has this structure:

```json
{
  "id": "772bf1026a72c400ea576db1ffa16407",
  "filter": {
    "id": "6f58318e7fa2477a23112e8118c66f61",
    "expression": "http.request.uri.path ~ \"^.*/wp-login.php$\" or http.request.uri.path ~ \"^.*/xmlrpc.php$\"",
    "paused": false,
    "description": "WordPress login paths",
    "ref": ""
  },
  "action": "challenge",
  "priority": 1000,
  "paused": false,
  "description": "Protect blog login page",
  "ref": ""
}
```

This table summarizes the object properties:

| Name | Description | Constraints |
| - | - | - |
| `id` String | A UUIDv4 identifier generated by Cloudflare. | Unique, read onlyLength: 32 characters |
| `filter` Object | A [Cloudflare Filter object](https://developers.cloudflare.com/firewall/api/cf-filters/json-object/) that contains an expression for evaluating this rule. | |
| `action` String | The action to take when a request satisfies the filter expression for this rule. | Refer to [Firewall rules actions](https://developers.cloudflare.com/firewall/cf-firewall-rules/actions/) for a list of supported values. |
| `priority` Number | Determines the order of evaluation for the rule relative to others. Lower values indicate greater priority. Rules without a value are evaluated last. For guidance, refer to [Avoiding priority conflicts](#avoiding-priority-conflicts). | Read onlyMaximum length: 32 |
| `paused` Boolean | Returns `true` when the rule is not active. Use `ref` to enable/disable the rule. | Default: `false` |
| `description` String | An informative summary of the rule. | Maximum length: 500 characters |
| `ref` String | A short string for tagging rules. | Maximum length: 50 characters |

## Avoiding priority conflicts

Priority plays a key role in configuring firewall rules. With Cloudflare Filters, it is possible to construct conflicting rules such as:

* Allow requests from the office IP range, and
* Block requests with a specific user agent.

Requests from the office IP range using the user agent to block would trigger both rules, but we cannot both allow and block the request. To solve this problem, firewall rules follows a strict ordering depending on action and priority.

Cloudflare prioritizes rules in descending order, such that priority 1 is first and rules with no priority are last. For rules of equal priority, Cloudflare orders them by action according to their [order of precedence](https://developers.cloudflare.com/firewall/cf-firewall-rules/actions/#supported-actions). In the example above, if no priority is set, the rule `allow request from the office IP range` would apply because the *allow* action has a higher precedence than *block*.

To reduce the risk of unintended behavior, it is best to explicitly specify the desired priority for potentially conflicting rules.
