---
title: Get started with Zero Trust · Cloudflare Learning Paths
description: In this learning path, you will learn how to replace your existing
  VPN provider with Cloudflare's ZTNA solution. Your users will run the WARP
  endpoint client on their devices, and you will run either Cloudflare Tunnel or
  Cloudflare WARP Connector in your network or on your application servers.
  After deploying Zero Trust, users will be able to connect to private resources
  (not exposed to the Internet) via TCP/UDP/ICMP, and administrators will be
  able to control access to these resources based on user identity, device
  posture, and other factors.
lastUpdated: 2025-08-20T18:47:44.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/replace-vpn/get-started/
  md: https://developers.cloudflare.com/learning-paths/replace-vpn/get-started/index.md
---

In this learning path, you will learn how to replace your existing VPN provider with Cloudflare's ZTNA solution. Your users will run the WARP endpoint client on their devices, and you will run either Cloudflare Tunnel or Cloudflare WARP Connector in your network or on your application servers. After deploying Zero Trust, users will be able to connect to private resources (not exposed to the Internet) via TCP/UDP/ICMP, and administrators will be able to control access to these resources based on user identity, device posture, and other factors.

![How Cloudflare connects a user device to a private network application](https://developers.cloudflare.com/_astro/cf1-ref-arch-10.PVIlTF5F_Zqb29Q.svg)

This guide will highlight best practices to follow and other decisions to consider when planning your deployment. Additionally, each module will include links to the key resources and how-to pages needed to get your deployment up and running.

Note

This learning path focuses on client-based remote access to internal services. If you are looking for clientless or browser-based functionality, refer to our [Deploy clientless access](https://developers.cloudflare.com/learning-paths/clientless-access/concepts/) learning path.

## Objectives

By the end of this module, you will be able to:

* Understand the high-level architecture and requirements for a ZTNA deployment to replace a legacy VPN.

- Set up a Cloudflare account.
- Create a Zero Trust organization to manage your devices and policies.
- Configure an identity provider (IdP) for user authentication.
