---
title: Create your first network policy · Cloudflare Learning Paths
description: You can control network-level traffic by filtering requests by
  selectors such as IP addresses and ports. You can also integrate network
  policies with an identity provider to apply identity-based filtering.
lastUpdated: 2024-12-12T16:10:12.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/secure-internet-traffic/build-network-policies/create-policy/
  md: https://developers.cloudflare.com/learning-paths/secure-internet-traffic/build-network-policies/create-policy/index.md
---

You can control network-level traffic by filtering requests by selectors such as IP addresses and ports. You can also integrate network policies with an [identity provider](https://developers.cloudflare.com/cloudflare-one/identity/idp-integration/) to apply identity-based filtering.

To create a new network policy:

* Dashboard

  1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **Gateway** > **Firewall policies**.

  2. In the **Network** tab, select **Add a policy**.

  3. Name the policy.

  4. Under **Traffic**, build a logical expression that defines the traffic you want to allow or block.

  5. Choose an **Action** to take when traffic matches the logical expression. For example, you can use a list of [device serial numbers](https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/corp-device/) to ensure users can only access an application if they connect with the WARP client from a company device:

     | Selector | Operator | Value | Logic | Action |
     | - | - | - | - | - |
     | SNI Domain | is | `internalapp.com` | And | Block |
     | Passed Device Posture Checks | not in | *Device serial numbers* | | |

  6. Select **Create policy**.

* API

  1. [Create an API token](https://developers.cloudflare.com/fundamentals/api/get-started/create-token/) with the following permissions:

     | Type | Item | Permission |
     | - | - | - |
     | Account | Zero Trust | Edit |

  2. (Optional) Configure your API environment variables to include your [account ID](https://developers.cloudflare.com/fundamentals/account/find-account-and-zone-ids/) and API token.

  3. Send a `POST` request to the [Create a Zero Trust Gateway rule](https://developers.cloudflare.com/api/resources/zero_trust/subresources/gateway/subresources/rules/methods/create/) endpoint. For example, you can use a list of [device serial numbers](https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/corp-device/) to ensure users can only access an application if they connect with the WARP client from a company device:

     Required API token permissions

     At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

     * `Zero Trust Write`

     ```bash
     curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
       --request POST \
       --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
       --json '{
         "name": "Enforce device posture",
         "description": "Ensure only devices in Zero Trust organization can connect to application",
         "precedence": 0,
         "enabled": true,
         "action": "block",
         "filters": [
             "l4"
         ],
         "traffic": "any(net.sni.domains[*] == \"internalapp.com\")",
         "identity": "",
         "device_posture": "not(any(device_posture.checks.passed[*] in {\"LIST_UUID\"}))"
       }'
     ```

  ```sh
  {
     "success": true,
     "errors": [],
     "messages": []
  }
  ```

  The API will respond with a summary of the policy and the result of your request.

For more information, refer to [network policies](https://developers.cloudflare.com/cloudflare-one/policies/gateway/network-policies/).
