---
title: Set up Private Network Load Balancing with WARP · Cloudflare Load
  Balancing docs
description: To use Private Network Load Balancing, you must first set up a
  Cloudflare Tunnel and a Virtual Local Area Network in the Cloudflare Zero
  Trust Dashboard. This guide walks you through all required steps, from setup
  to optional configurations.
lastUpdated: 2025-09-03T10:05:39.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/load-balancing/private-network/warp/
  md: https://developers.cloudflare.com/load-balancing/private-network/warp/index.md
---

To use Private Network Load Balancing, you must first set up a Cloudflare Tunnel and a Virtual Local Area Network in the [Cloudflare Zero Trust Dashboard](http://one.dash.cloudflare.com). This guide walks you through all required steps, from setup to optional configurations.

## 1. Create Tunnel and Virtual Network

Skip to [step 2](https://developers.cloudflare.com/load-balancing/private-network/warp/#2-create-load-balancer-pools) if you already have a Cloudflare Tunnel and Virtual Network created.

### 1.1 Create a Cloudflare Tunnel

1. Log in to the [Zero Trust dashboard](http://one.dash.cloudflare.com).
2. Go to **Networks** > **Tunnels**.
3. Select **Create a tunnel**.
4. Choose **Cloudflared** for the connector type.
5. Enter a name for your tunnel. We suggest choosing a name that reflects the type of resources you want to connect through this tunnel (for example, `enterprise-VPC-01`).
6. Select **Save tunnel**.
7. Next, make sure the environment under **Choose your environment** matches your operating system, then copy the provided command, paste it into your terminal, and run it to install and launch `cloudflared`.
8. Once the command has finished running, your connector will appear in the Zero Trust dashboard.

For more details, refer to the [Create tunnel](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/get-started/create-remote-tunnel/) documentation.

### 1.2 Create a Virtual Network

1. In the [Zero Trust dashboard](http://one.dash.cloudflare.com), go to **Settings** > **WARP Client**.
2. Under **Network locations**, find **Virtual networks** settings.
3. Select **Add new** or **Manage** > **Create virtual network**.
4. Name your virtual network and select **Save**.
5. To assign the virtual network to the tunnel go to **Networks** > **Tunnels**.
6. Select the tunnel created in the previous steps and select **Edit**.
7. Under **Private Network**, select **Add a private network**.
8. Enter the CIDR IP range for your private network.
9. Under **Additional settings**, select the virtual network you created.
10. Select **Save private network**.

For more details, refer to the [Virtual Network](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/private-net/cloudflared/tunnel-virtual-networks/) documentation. For API-specific details, refer to the [virtual networks](https://developers.cloudflare.com/api/resources/zero_trust/subresources/networks/subresources/virtual_networks/) API documentation.

The Tunnel and Virtual Network can be found under **Settings** > **WARP Client** in the Zero Trust dashboard.

## 2. Create Load Balancer Pools

Load Balancer Pools are logical groupings of endpoints — typically organized by physical datacenter or geographic region. The endpoints in the pool are the destinations where traffic is ultimately routed.

Note

If your endpoint address is an RFC 1918 private IP address, you must assign a Virtual Network (VNET) that includes the corresponding CIDR range.

Pools can be created using either the Cloudflare dashboard or the API. Refer to the [Create a pool](https://developers.cloudflare.com/load-balancing/pools/create-pool/#create-a-pool) documentation section for more information.

## 3. Create an Account Load Balancer with a Private IP

1. In the Cloudflare dashboard, go to the **Load Balancing** page.

   [Go to **Load balancing**](https://dash.cloudflare.com/?to=/:account/load-balancing)

2. Select **Create a Load Balancer**.

3. Select **Private Load Balancer**.

4. On the next step you can choose to associate this load balancer with either:

* A CGNAT IP from the Cloudflare range or
* A custom [RFC1918 address](https://datatracker.ietf.org/doc/html/rfc1918).

1. Add a descriptive name to identify your Load Balancer.
2. Proceed through the setup.

After selecting an IP address and completing the setup, you will be redirected to the Load Balancing dashboard. You can locate your load balancer using the search bar or by filtering for **Private** load balancers. Be sure to note the assigned IP address as it will be required in the following steps.

## 4. Make CGNAT IP routable (optional)

If you are using an automatically assigned CGNAT IP address, you may need to update your Zero Trust settings to make this IP address accessible to WARP users.

### Update Split Tunnel settings

1. In Zero Trust, go to **Settings** > **WARP Client**.
2. Under **Device settings**, find the [device profile](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/device-profiles/) you would like to modify and select **Edit**.
3. Under **Split Tunnels**, check whether your [Split Tunnels mode](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/split-tunnels/#change-split-tunnels-mode) is set to **Exclude** or **Include**.
4. Select **Manage**. Depending on the mode:

* Exclude Mode: Delete the `100.64.0.0/10` entry.
* Include Mode: Add `100.64.0.0/10` as an allowed range.

WARP traffic can now reach your Private Load Balancer at its CGNAT IP address. This traffic will be distributed over Tunnel to your private endpoints according to your configured steering method.

## 5. FQDN override (optional)

If you want your load balancer and its endpoints to be transparently accessible to users via a hostname, you can create an override that maps the hostname to the Load Balancer's IP address. This ensures that traffic destined for the hostname resolves to the correct IP.

1. In **Gateway**, select **Firewall policies**.
2. In the **DNS**\*\* tab, create an override where the **Selector** equals `Host`, the **Operator** equals `is`, and the **Value** is the hostname you wish to associate with your load balancer.
3. Set the **Action** to *Override* and in **Override Hostname**, enter the IP address of your Private Load Balancer.

Requests to the hostname will now resolve to your private load balancer.
