---
title: Magic Network Monitoring · Cloudflare Magic Transit docs
description: Magic Transit On Demand customers can use Magic Network Monitoring
  to analyze their network traffic and detect DDoS attacks while Magic Transit
  is disabled. If an attack is detected, customers can automatically or manually
  enable Magic Transit to mitigate DDoS attacks.
lastUpdated: 2025-09-25T14:23:12.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-transit/magic-network-monitoring/
  md: https://developers.cloudflare.com/magic-transit/magic-network-monitoring/index.md
---

[Magic Transit On Demand](https://developers.cloudflare.com/magic-transit/on-demand/) customers can use Magic Network Monitoring to analyze their network traffic and detect DDoS attacks while Magic Transit is disabled. If an attack is detected, customers can automatically or manually enable Magic Transit to mitigate DDoS attacks.

Customers can create Magic Network Monitoring rules which will monitor specific IP prefixes for DDoS attacks. When a DDoS attack is detected, Cloudflare will notify you by email, [webhook](https://developers.cloudflare.com/notifications/get-started/configure-webhooks/), or [PagerDuty](https://developers.cloudflare.com/notifications/get-started/configure-pagerduty/) with information about the attack. Then, you can choose to [automatically activate IP advertisement](#activate-ip-auto-advertisement) and enable Magic Transit to protect the targeted IP prefixes from DDoS attacks. This feature is referred to as auto-advertisement, and you can enable it for individual Magic Network Monitoring rules via the dashboard or API.

After Magic Transit is activated and your traffic is flowing through Cloudflare, malicious DDoS traffic will be blocked, and your origin servers will only receive clean network traffic via IPsec or GRE tunnels.

The diagrams below illustrate this process:

![The diagram shows the flow of traffic when you send flow data from your network to Cloudflare for analysis.](https://developers.cloudflare.com/_astro/1-flowdata.C2Oap_Pf_Z1gWWoP.webp)

![Cloudflare automatically notifies you when we detect an attack based on your flow data.](https://developers.cloudflare.com/_astro/2-flowdata.DLOwyPqi_1oW4X.webp)

![You can create rules to activate Magic Transit automatically, to protect your IP addresses from a DDoS attack.](https://developers.cloudflare.com/_astro/3-flowdata.CiegeHTC_Z1UVRCd.webp)

## Activate IP auto-advertisement

You need to enable IP auto-advertisement in order to use Magic Network Monitoring rules. You can activate IP auto-advertisement via the dashboard or the API.

### Dashboard

To activate IP advertisement via the Cloudflare dashboard, refer to [Configure dynamic advertisement](https://developers.cloudflare.com/byoip/concepts/dynamic-advertisement/best-practices/#configure-dynamic-advertisement).

### API

To activate IP advertisement via the API, refer to the [IP Address Management Dynamic Advertisement API](https://developers.cloudflare.com/api/resources/addressing/subresources/prefixes/subresources/advertisement_status/methods/edit/).

## Magic Network Monitoring rules

To create Magic Network Monitoring rules with auto-advertisement, refer to [Rule Auto-Advertisement](https://developers.cloudflare.com/magic-network-monitoring/rules/#rule-auto-advertisement).
