---
title: Route to a different origin based on origin response · Cloudflare Rules docs
description: If response to the original request is not `200 OK` or a redirect,
  send to another origin.
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
tags: Redirects
source_url:
  html: https://developers.cloudflare.com/rules/snippets/examples/serve-different-origin/
  md: https://developers.cloudflare.com/rules/snippets/examples/serve-different-origin/index.md
---

```js
export default {
  async fetch(request) {
    // Send original request to the origin
    const response = await fetch(request);


    // If response is not 200 OK or a redirect, send to another origin
    if (!response.ok && !response.redirected) {
      // First, clone the original request to construct a new request
      const newRequest = new Request(request);
      // Add a header to identify a re-routed request at the new origin
      newRequest.headers.set("X-Rerouted", "1");
      // Clone the original URL
      const url = new URL(request.url);
      // Send request to a different origin / hostname
      url.hostname = "example.com";
      // Serve response to the new request from the origin
      return await fetch(url, newRequest);
    }


    // If response is 200 OK or a redirect, serve it
    return response;
  },
};
```
