---
title: Create a redirect rule using Terraform · Cloudflare Rules docs
description: The following example defines a single redirect rule for a zone
  using Terraform. The rule creates a static URL redirect for visitors
  requesting the contacts page using an old URL.
lastUpdated: 2025-08-22T14:24:45.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/url-forwarding/single-redirects/terraform-example/
  md: https://developers.cloudflare.com/rules/url-forwarding/single-redirects/terraform-example/index.md
---

Note

Terraform code snippets below refer to the v4 SDK only.

The following example defines a single redirect rule for a zone using Terraform. The rule creates a static URL redirect for visitors requesting the contacts page using an old URL.

```tf
# Single Redirects resource
resource "cloudflare_ruleset" "single_redirects_example" {
  zone_id     = "<ZONE_ID>"
  name        = "redirects"
  description = "Redirects ruleset"
  kind        = "zone"
  phase       = "http_request_dynamic_redirect"


  rules {
    ref         = "redirect_old_url"
    description = "Redirect visitors still using old URL"
    expression  = "(http.request.uri.path matches \"^/contact-us/\")"
    action      = "redirect"
    action_parameters {
      from_value {
        status_code = 301
        target_url {
          value = "/contacts/"
        }
        preserve_query_string = false
      }
    }
  }
}
```

Use the `ref` field to get stable rule IDs across updates when using Terraform. Adding this field prevents Terraform from recreating the rule on changes. For more information, refer to [Troubleshooting](https://developers.cloudflare.com/terraform/troubleshooting/rule-id-changes/#how-to-keep-the-same-rule-id-between-modifications) in the Terraform documentation.

## Additional resources

For additional guidance on using Terraform with Cloudflare, refer to the following resources:

* [Terraform documentation](https://developers.cloudflare.com/terraform/)
* [Cloudflare Provider for Terraform](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs) (reference documentation)
