---
title: http.request.uri.path.extension · Cloudflare Ruleset Engine docs
description: The lowercased file extension in the URI path without the dot (`.`) character.
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.request.uri.path.extension/
  md: https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.request.uri.path.extension/index.md
---

# http.request.uri.path.extension

`http.request.uri.path.extension` String

The lowercased file extension in the URI path without the dot (`.`) character.

This corresponds to the string after the last dot in the URI path, excluding the query string.

If the first character of the last path segment is a dot and the segment does not contain other dot characters, the field value will be an empty string (`""`). Having a dot as the first character does not represent a file extension and is commonly used in UNIX-like systems to denote a hidden file or directory.

Example values:

* If the URI path is `/articles/index.html`, the field value will be `"html"`.
* If the URI path is `/articles/index.`, the field value will be an empty string (`""`).

Example values:

| URI path | Field value |
| - | - |
| `/foo` | `""` |
| `/foo.mp3` | `"mp3"` |
| `/.mp3` | `""` |
| `/.foo.mp3` | `"mp3"` |
| `/foo.tar.bz2` | `"bz2"` |
| `/foo.` | `""` |
| `/foo.MP3` | `"mp3"` |

Categories:

* Request
* URI
