---
title: Changelog · Cloudflare Security Center docs
description: Brand Protection detects domains that may be impersonating your
  brand — from common misspellings (cloudfalre.com) to malicious concatenations
  (cloudflare-okta.com). Saved search queries run continuously and alert you
  when suspicious domains appear.
lastUpdated: 2025-08-08T13:53:13.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/security-center/changelog/
  md: https://developers.cloudflare.com/security-center/changelog/index.md
---

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/security-center.xml)

## 2025-08-15

**Save time with bulk query creation in Brand Protection**

[Brand Protection](https://developers.cloudflare.com/security-center/brand-protection/) detects domains that may be impersonating your brand — from common misspellings (`cloudfalre.com`) to malicious concatenations (`cloudflare-okta.com`). Saved search queries run continuously and alert you when suspicious domains appear.

You can now create and save multiple queries in a single step, streamlining setup and management. Available now via the [Brand Protection bulk query creation API](https://developers.cloudflare.com/api/resources/brand_protection/subresources/queries/methods/bulk/).

## 2025-07-18

**New APIs for Brand Protection setup**

The Brand Protection API is now available, allowing users to create new queries and delete existing ones, fetch matches and more!

What you can do:

* **create new string or logo query**
* **delete string or logo queries**
* **download matches for both logo and string queries**
* **read matches for both logo and string queries**

Ready to start? Check out the [Brand Protection API](https://developers.cloudflare.com/api/resources/brand_protection/) in our documentation.

## 2025-05-08

**URL Scanner now supports geo-specific scanning**

Enterprise customers can now choose the geographic location from which a URL scan is performed — either via [Security Center](https://developers.cloudflare.com/security-center/investigate/) in the Cloudflare dashboard or via the [URL Scanner API](https://developers.cloudflare.com/api/resources/url_scanner/subresources/scans/methods/create/).

This feature gives security teams greater insight into how a website behaves across different regions, helping uncover targeted, location-specific threats.

**What’s new:**

* Location Picker: Select a location for the scan via **Security Center → Investigate** in the dashboard or through the API.
* Region-aware scanning: Understand how content changes by location — useful for detecting regionally tailored attacks.
* Default behavior: If no location is set, scans default to the user’s current geographic region.

Learn more in the [Security Center documentation](https://developers.cloudflare.com/security-center/).

## 2025-02-03

* Security Center now has a role called Brand Protection. This role gives you access to the Brand Protection feature on the API and Cloudflare dashboard. Brand Protection role also gives you access to the Investigate platform, where you can consume the Threat Intel API and URL scanner API calls.

## 2025-01-20

* On the URL scanner, customers who search for a report will now get a list of all reports related to that specific hostname. A hash is also available in the security report. By selecting the hash, the dashboard will list reports containing the same hash.

## 2024-09-23

* Customers can now export all matches from a saved query. Select your **Query name** > select the three dots > **Export matches**.

## 2024-09-19

* Customers can now create a `security.txt` file file to provide the security research team with a standardized way to report vulnerabilities.

## 2024-07-22

* Customers can now archive multiple Security Insights at the same time. Go to **Security Center** > **Security Insights** and select the insights to archive.
