---
title: Client certificates (mTLS) · Cloudflare SSL/TLS docs
description: Use Cloudflare public key infrastructure (PKI) to create client
  certificates and enforce mutual Transport Layer Security (mTLS) encryption.
lastUpdated: 2025-07-21T16:17:45.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ssl/client-certificates/
  md: https://developers.cloudflare.com/ssl/client-certificates/index.md
---

Use Cloudflare's public key infrastructure (PKI) to create client certificates, or [bring your own CA for mTLS](https://developers.cloudflare.com/ssl/client-certificates/byo-ca/).

[Mutual TLS (mTLS)](https://www.cloudflare.com/learning/access-management/what-is-mutual-tls/) authentication is a common security practice that uses client certificates to ensure traffic between client and server is bidirectionally secure and trusted. mTLS also allows requests that do not authenticate via an identity provider — such as Internet-of-things (IoT) devices — to demonstrate they can reach a given resource.

mTLS at Cloudflare

For a broader overview, refer to the [mTLS at Cloudflare learning path](https://developers.cloudflare.com/learning-paths/mtls/concepts/).

***

## How it works

Client certificates issued from a given CA are installed on client devices that should be granted access. Then, for any host that has [mTLS enabled](https://developers.cloudflare.com/ssl/client-certificates/enable-mtls/), Cloudflare - acting as the server in this case - requires a certificate from the client trying to access the hostname.

Cloudflare then validates the client certificate against CAs set at account level. This means that these certificates can be used for validation across multiple zones/domains (`example.com`), as long as the zones are under the same Cloudflare account and mTLS has been enabled for the requested hosts (`host.example.com`).

The account-level CAs can be:

* The Cloudflare-managed CA: This is the default option. Certificates and hostname associations are listed on your [dashboard](https://dash.cloudflare.com/?to=/:account/:zone/ssl-tls/client-certificates/).
* [BYOCA](https://developers.cloudflare.com/ssl/client-certificates/byo-ca/) certificates: This is an API-only option, available on Enterprise accounts. Certificates and hostname associations are **not** listed on your [dashboard](https://dash.cloudflare.com/?to=/:account/:zone/ssl-tls/client-certificates/).

***

## Use cases

As explained in the [mTLS learning path](https://developers.cloudflare.com/learning-paths/mtls/concepts/), there are different use cases and implementation options for mTLS. Consider the following links for specific guidance.

* [Application security](https://developers.cloudflare.com/learning-paths/mtls/mtls-app-security/)
* [mTLS for Zero Trust](https://developers.cloudflare.com/cloudflare-one/identity/devices/access-integrations/mutual-tls-authentication/) (Cloudflare Access integration)
* [mTLS with API Shield](https://developers.cloudflare.com/api-shield/security/mtls/configure/)
* [mTLS Workers binding](https://developers.cloudflare.com/workers/runtime-apis/bindings/mtls/)

Apart from the mTLS Workers binding, any of the above implementations can use your own CA instead of the Cloudflare-managed one. Refer to [Bring your own CA](https://developers.cloudflare.com/ssl/client-certificates/byo-ca/).

### mTLS and Workers

Use the [mTLS Workers binding](https://developers.cloudflare.com/workers/runtime-apis/bindings/mtls/) when you need your worker to present a client certificate to an external service. To authenticate requests from a client to your worker instead, refer to [SSL/TLS > Client certificates](https://dash.cloudflare.com/?to=/:account/:zone/ssl-tls/client-certificates/) and the regular [mTLS for application security](https://developers.cloudflare.com/learning-paths/mtls/mtls-app-security/) implementation.

```mermaid
flowchart LR
        accTitle: mTLS from client to worker versus mTLS from worker to external service
        accDescr: Diagram showing two different implementations that can be considered for mTLS with Cloudflare Workers.
        A[Client] <--App security mTLS--> B((Cloudflare))<--mTLS worker binding--> C[(External service)]
```
