---
title: Examples · Cloudflare Style Guide
description: A code sample or line of text that shows the specific structure of
  a request/response, input/output, or value for UI/API elements
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/examples/
  md: https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/examples/index.md
---

## Definition

A code sample or line of text that shows the specific structure of a request/response, input/output, or value for UI/API elements

Note

If you are unsure about when to categorize something as an example or tutorial, remember:

Examples are a component attribute and are typically a snippet of code a user might copy and paste to run a task. Examples should not have multiple steps. A tutorial might contain an example, but an example will not contain a tutorial.

Tutorials are a content type, typically longer form, and contain multiple steps to help users connect products to real-world scenarios.

## Used in

[Tutorial](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/tutorial/), [How to](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/how-to/), [Reference](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/reference/)

## Structure

**Context**

Explain what the code sample does in a short sentence.

**Code blocks or snippets**

These could include:

* Example requests and responses
* Example inputs and outputs
* Field values for UI and/or API

## Additional information

[Code block guidelines](https://developers.cloudflare.com/style-guide/formatting/code-block-guidelines/)

## Requests/feedback

<https://github.com/cloudflare/cloudflare-docs/issues/150>
