---
title: Contacting Cloudflare Support · Cloudflare Support docs
description: Learn how to contact Cloudflare Support via community, chat, or
  phone. Get help with issues, verify identity, and understand SLAs for
  different plans.
lastUpdated: 2025-10-13T21:06:48.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/support/contacting-cloudflare-support/
  md: https://developers.cloudflare.com/support/contacting-cloudflare-support/index.md
---

## Guidelines for contacting Cloudflare support

Cloudflare Support *cannot* perform the following actions:

* Make configuration or account changes on a customer’s behalf
* Provide sensitive account info over the phone
* Troubleshoot or debug customer's code and its logic
* Troubleshoot or answer questions about domains not associated with the Cloudflare account email address used to contact support

Warning

**Do not share** any sensitive information, such as passwords, credit card numbers, private keys, or API keys with Cloudflare.

Before notifying Cloudflare of an issue with your site, refer to the [Cloudflare Status Page](https://www.cloudflarestatus.com/). If reporting issues with your site, ensure to provide adequate details in the support case *(refer to [Getting help with an issue](#getting-help-with-an-issue) for more information)*.

***

## Methods of contacting Cloudflare support

As a Cloudflare customer, you can contact Cloudflare for support via the community portal or by opening a support case, live chat, or phone. Support options can vary depending on your plan.

| | Enterprise | Business | Pro | Free |
| - | - | - | - | - |
| [Community](https://community.cloudflare.com/) Join the community to ask basic troubleshooting questions and to view the latest resources (such as tips for resolving common issues and configuration guidance). | Yes | Yes | Recommended | Recommended |
| [Discord](https://discord.cloudflare.com/) Join the Discord community to ask basic troubleshooting questions (mainly focused on the Developer Platform). | Yes | Yes | Recommended | Recommended |
| [Support case](#getting-help-with-an-issue) Use to troubleshoot specific issues or errors. Response times depend on your plan. | Yes | Yes | Yes | No\* |
| **Chat** Use to troubleshoot specific issues or errors. Response times depend on your plan. | Yes | Yes | No | No |
| **Emergency Phone** Use phone support to reach out during emergencies such as site outages or DDoS attacks. | Yes | No | No | No |

***

Note

Customers on Free plans are encouraged to utilize our Cloudflare Community and will only receive standard case support for billing, account, and registrar issues.

## Verifying your identity on phone calls

*(For Enterprise Emergency Phone Support)*

For account security, you must verify your identity and account ownership in the Cloudflare dashboard before discussing account settings and sensitive details with Cloudflare Support. There are two verification options:

* a single-use token that automatically refreshes every thirty (30) seconds, or
* an [authenticator app token](https://developers.cloudflare.com/fundamentals/user-profiles/2fa/#configure-totp-mobile-application-authentication) on your mobile device.

### Authenticating your account

1. In the Cloudflare dashboard, go to the **Support** page and select the account you are calling about.

[Go to Support](https://dash.cloudflare.com/?to=/:account/support)

1. Click on the **Technical Support** tile and then the **Emergency Phone Line** tile.

2. To authenticate using a single-use token, click on the **Get a single-use token** button. A pop-up window will appear with your Unique Customer Id and One Time Passcode. The code automatically refreshes every 30 seconds.

![](https://developers.cloudflare.com/_astro/Emergency_Phone_Support.IYDzAqH8_1FdHyi.webp)

1. To authenticate using an authenticator app, click **Configure authenticator app** and follow the [configuration instructions](https://developers.cloudflare.com/fundamentals/user-profiles/2fa/#configure-totp-mobile-application-authentication) on the following screen. After configuration, the token code will appear in your mobile authentication application.

2. When calling the emergency phone line, you can authenticate automatically by entering your ID and Code when requested.

***

## Getting help with an issue

To submit a support case, follow these steps:

1. In the Cloudflare dashboard, go to the **Support** page and select the account you require assistance for.

[Go to Support](https://dash.cloudflare.com/?to=/:account/support)

1. Click on the **Technical Support** tile, or for billing issues click **Billing** and then click **Create a Case** at the bottom of the following screen.

2. Choose the category and subcategories that best define your issue.

3. Choose the affected domains (if applicable).

4. Enter a detailed summary of the issue you’re experiencing.

5. Complete the case submission fields as completely as possible with the following information. *(**Please note** that missing information will increase the time it takes to resolve your issue and our team may not be able to investigate without enough information. Please review [Gathering information for troubleshooting sites](https://developers.cloudflare.com/support/troubleshooting/general-troubleshooting/gathering-information-for-troubleshooting-sites/) and make sure you include all needed information.)* - A detailed description of the issue with the following information:

   * Timestamp (UTC)
   * ZoneName/ZoneID
   * Problem frequency
   * Steps to reproduce the issue, with actual results vs expected results - Any necessary information for a technical investigation
   * A description of the actual results vs expected results
   * Steps to reproduce the issue, with example URLs 
   * Exact error messages
   * HAR files
   * Screenshots
   * Relevant logs from the origin web server
   * Output from [test tools](https://developers.cloudflare.com/support/troubleshooting/general-troubleshooting/gathering-information-for-troubleshooting-sites/) such as MTR, traceroute, dig/nslookup, and cURL - Priority level, impact to service / production - Any collaborators whom you wish to be cc'd on the case

6. Click **Submit Case**

\*\* Available to certain plan types only. Refer to chart above for details.

### Accepted file formats in cases and chats

You can only upload the following file types in a case or a chat:

*Image*

* png, jpg, gif, ico, tiff

*Video*

* mp4, avi, webm

*Text*

* har, txt, csv, eml, css, html, json, tf

*Packet Capture*

* pcap, pcapng, cap

Cloudflare Support only accepts the WARP diagnostics as compressed files. Please do not upload ZIP or RAR files when sharing HAR files, and please do not share compressed documents like DOCX, XLSX or PPTX.

The maximum file size is **20 MB**. If you need to share a larger file, please provide a link to the file using Google Drive or a similar sharing platform of your choice.

When sending Cloudflare Support packet captures, please do the following:

1. Filter for relevant traffic. Use a display filter and then save [export specified packets](https://www.wireshark.org/docs/wsug_html_chunked/ChIOExportSection.html) to reduce the file size.
2. Include the name of the device and interface/tunnel in the file name.
3. Describe what each packet capture shows.

### View open support cases

1. In the Cloudflare dashboard, go to the **Support** page.

[Go to Support](https://dash.cloudflare.com/?to=/:account/support)

1. Click on **Get help**

2. Select the account you require assistance for

3. Click on the **Technical Support** tile followed by **View My Cases**.

4. You will be redirected to the portal where you can see your own cases and cases you are CC'd on.

### Add participants to open support tickets

1. In the Cloudflare dashboard, go to the **Support** page and select the account you require assistance for.

[Go to Support](https://dash.cloudflare.com/?to=/:account/support)

1. Click on the **Technical Support** tile followed by **View My Cases**.

2. You will be redirected to the portal where you can see your own cases and cases you are CC'd on.

3. Select the case you want to add participants to.

4. Enter their email in the `Case Participants` box in the top right and click **Add**.

***

## Live chat support

You can also use the **live chat** (Business and Enterprise plans, only) to ask specific questions that don’t require a lot of technical investigation:

1. Log in to your **Cloudflare dashboard** and select the **account** you need assistance with.

2. Access the **Live Chat** based on your plan type:

   * **Enterprise Customers**: Click the **Chat icon** in the bottom right corner of the screen to open the Cloudflare Chat widget immediately.

   * **Business Plan Customers**:

     * In the Cloudflare dashboard, go to the **Support** page and select the account you require assistance for. [Go to Support](https://dash.cloudflare.com/?to=/:account/support)
     * Click on the **Technical Support** tile followed by **Chat with an agent**.
     * Fill-out the required form to start a Chat session.

The Cloudflare Chat widget will open, send an initial message describing your problem to start chatting with an agent.

***

## Service Level Agreements and Objectives

### How we prioritize your issue

Cloudflare support responds to every case received in the following priority order:

* Premium Enterprise
* Standard Enterprise
* Business
* Pro
* Free

Cloudflare Support strives to respond to our customers as quickly as possible. Urgent issues (site down, under attack) are prioritized for the quickest response possible. Please explicitly specify the priority level and impact to your production service when reaching out to Cloudflare support.

Below are definitions of the priority levels Cloudflare assigns to cases and the associated Service Level Agreement (SLA) or Service Level Objective (SLO). Whenever possible, responses are provided quicker than the noted SLAs.

### Priority definitions

* P1 Urgent- Critical Business Impact: Severe disruption to your business operations. This issue requires immediate and ongoing attention from both Cloudflare as well as yourself as it directly affects revenue, users, or business continuity.

  * *Example*: Your websites, applications, or services are completely unavailable or severely impaired across multiple regions or ISPs.
  * *Example*: A confirmed, active security attack is causing major disruptions, such as denial of service, data breaches, or account compromises.

* P2 High - High Business Impact: Significant but localized service or security disruption. While not a full outage, this issue affects business operations and requires urgent resolution.

  * *Example*: A recurring or persistent issue is affecting a portion of your users, such as degraded performance, intermittent outages, or limited accessibility.
  * *Example*: A past, confirmed security attack has resulted in measurable impact, requiring investigation and mitigation to prevent recurrence.

* P3 Normal - Moderate Business Impact: Limited service impact or suspected security concerns. The issue does not pose an immediate risk but requires attention for continued reliability.

  * *Example*: Your service is operational, but you are experiencing minor disruptions, such as performance fluctuations, unexpected behavior, or non-critical bugs.
  * *Example*: A suspected security threat has been detected but is currently mitigated (e.g., an attack that Cloudflare successfully blocked).

* P4 Low - Low Business Impact: General inquiries and non-urgent requests. The issue does not impact your service availability or business operations.

  * *Example*: You are requesting feature enhancements or recommendations for improving security or performance.
  * *Example*: You have questions about Cloudflare’s products, documentation, or best practices.

### Premium SLA

* P1 Urgent- initial response in 1 hour
* P2 High - initial response in 2 hours 
* P3 Normal - initial response in 24 hours 
* P4 Low - initial response in 24 hours

### Enterprise SLA

* P1 Urgent - initial response in 2 hours
* P2 High - initial response in 4 hours
* P3 Normal - initial response in 48 hours
* P4 Low - initial response in 48 hours

### SLOs for other plans

* PAYGO and Free customers - No SLAs are offered, but customers are responded to in the order in which their request is received. For a quicker answer, we highly recommend searching or posting on our [Community forums](https://community.cloudflare.com/).

## Supported languages

For Enterprise support, Cloudflare provides support in English, but makes a best effort to offer help in the following languages:

* Chinese
* French
* German
* Japanese
* Portuguese
* Spanish

## Supported regions

Cloudflare offers worldwide support, which covers:

* Asia-Pacific
* Europe, Middle East, and Africa
* North and South America
